/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/java_ingesttesterlistenerproxy.h"

#include "twitchsdk/broadcast/generated/java_all.h"
#include "twitchsdk/broadcast/java_broadcastutil.h"

using namespace ttv::broadcast;

ttv::binding::java::JavaIngestTesterListenerProxy::JavaIngestTesterListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IIngestTesterListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaIngestTesterListenerProxy::BroadcastIngestTesterStateChanged(IIngestTester* /*source*/) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["ingestTesterStateChanged"]);
}
