/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/generated/java_videoparamsimpl.h"

#include "twitchsdk/broadcast/generated/java_all.h"
#include "twitchsdk/broadcast/java_broadcastutil.h"

using namespace ttv;
using namespace ttv::broadcast;
using namespace ttv::binding::java;

JNIEXPORT jobject JNICALL Java_tv_twitch_broadcast_VideoParams_configureForBandwidth(JNIEnv* jEnv, jclass /*jClass*/,
  jint jExpectedKbps, jint jFramesPerSecond, jfloat jBitsPerPixel, jfloat jAspectRatio, jobject jResultContainer) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  VideoParams result;
  TTV_ErrorCode ec =
    VideoParams::ConfigureForBandwidth(static_cast<uint32_t>(jExpectedKbps), static_cast<uint32_t>(jFramesPerSecond),
      static_cast<float>(jBitsPerPixel), static_cast<float>(jAspectRatio), result);
  if (TTV_SUCCEEDED(ec)) {
    AUTO_DELETE_LOCAL_REF(jEnv, jobject, jResult, GetJavaInstance_VideoParams(jEnv, result));
    SetResultContainerResult(jEnv, jResultContainer, jResult);
  }

  return GetJavaInstance_ErrorCode(jEnv, ec);
}

JNIEXPORT jobject JNICALL Java_tv_twitch_broadcast_VideoParams_configureForResolution(JNIEnv* jEnv, jclass /*jClass*/,
  jint jWidth, jint jHeight, jint jFramesPerSecond, jfloat bitsPerPixel, jobject jResultContainer) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  VideoParams result;
  TTV_ErrorCode ec = VideoParams::ConfigureForResolution(static_cast<uint32_t>(jWidth), static_cast<uint32_t>(jHeight),
    static_cast<uint32_t>(jFramesPerSecond), static_cast<float>(bitsPerPixel), result);
  if (TTV_SUCCEEDED(ec)) {
    AUTO_DELETE_LOCAL_REF(jEnv, jobject, jResult, GetJavaInstance_VideoParams(jEnv, result));
    SetResultContainerResult(jEnv, jResultContainer, jResult);
  }

  return GetJavaInstance_ErrorCode(jEnv, ec);
}
