/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/generated/jni_passthroughvideocapture.h"

#include "twitchsdk/broadcast/generated/java_all.h"
#include "twitchsdk/broadcast/java_broadcastutil.h"
#include "twitchsdk/broadcast/passthroughvideocapture.h"

#include <functional>

using namespace ttv;
using namespace ttv::broadcast;
using namespace ttv::binding::java;

#define GET_NATIVE_PTR(x) reinterpret_cast<PassThroughVideoCapture*>(x)

JNIEXPORT jlong JNICALL Java_tv_twitch_broadcast_PassThroughVideoCapture_CreateNativeInstance(
  JNIEnv* jEnv, jobject jThis) {
  std::shared_ptr<PassThroughVideoCaptureContext> context = std::make_shared<PassThroughVideoCaptureContext>();
  context->instance = std::make_shared<PassThroughVideoCapture>();

  gPassThroughVideoCaptureInstanceRegistry.Register(context->instance, context, jThis);

  return reinterpret_cast<jlong>(context->instance.get());
}

JNIEXPORT void JNICALL Java_tv_twitch_broadcast_PassThroughVideoCapture_DisposeNativeInstance(
  JNIEnv* jEnv, jobject jThis, jlong jNativePointer) {
  gPassThroughVideoCaptureInstanceRegistry.Unregister(jNativePointer);
}

JNIEXPORT jstring JNICALL Java_tv_twitch_broadcast_PassThroughVideoCapture_GetName(
  JNIEnv* jEnv, jobject jThis, jlong jNativePointer) {
  auto capturer = GET_NATIVE_PTR(jNativePointer);

  auto context = gPassThroughVideoCaptureInstanceRegistry.LookupNativeContext(jNativePointer);
  if (context != nullptr) {
    auto name = capturer->GetName();
    return GetJavaInstance_String(jEnv, name);
  } else {
    return nullptr;
  }
}

JNIEXPORT jobject JNICALL Java_tv_twitch_broadcast_PassThroughVideoCapture_Initialize(
  JNIEnv* jEnv, jobject jThis, jlong jNativePointer) {
  auto capturer = GET_NATIVE_PTR(jNativePointer);

  TTV_ErrorCode ec = TTV_EC_INVALID_INSTANCE;

  auto context = gPassThroughVideoCaptureInstanceRegistry.LookupNativeContext(jNativePointer);
  if (context != nullptr) {
    ec = capturer->Initialize();
  }

  return GetJavaInstance_ErrorCode(jEnv, ec);
}

JNIEXPORT jobject JNICALL Java_tv_twitch_broadcast_PassThroughVideoCapture_Shutdown(
  JNIEnv* jEnv, jobject jThis, jlong jNativePointer) {
  auto capturer = GET_NATIVE_PTR(jNativePointer);

  TTV_ErrorCode ec = TTV_EC_INVALID_INSTANCE;

  auto context = gPassThroughVideoCaptureInstanceRegistry.LookupNativeContext(jNativePointer);
  if (context != nullptr) {
    ec = capturer->Shutdown();
  }

  return GetJavaInstance_ErrorCode(jEnv, ec);
}

JNIEXPORT jobject JNICALL Java_tv_twitch_broadcast_PassThroughVideoCapture_EnqueueVideoPacket(
  JNIEnv* jEnv, jobject jThis, jlong jNativePointer, jbyteArray jVideoPacket, jboolean jKeyframe, jlong jTimestamp) {
  TTV_JNI_RETURN_ON_NULL(jEnv, jVideoPacket, TTV_EC_INVALID_ARG);

  auto capturer = GET_NATIVE_PTR(jNativePointer);

  TTV_ErrorCode ec = TTV_EC_INVALID_INSTANCE;

  auto context = gPassThroughVideoCaptureInstanceRegistry.LookupNativeContext(jNativePointer);
  if (context != nullptr) {
    // Bring the bytes into native
    std::vector<uint8_t> videoPacket;
    GetNativeFromJava_ByteArray(jEnv, jVideoPacket, videoPacket);

    // Enqueue the packet
    ec = capturer->EnqueueVideoPacket(std::move(videoPacket), jKeyframe == JNI_TRUE, static_cast<uint64_t>(jTimestamp));
  }

  return GetJavaInstance_ErrorCode(jEnv, ec);
}
