/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/generated/jni_broadcasttest.h"
#include "twitchsdk/broadcast/java_bandwidthstatlistenerproxy.h"
#include "twitchsdk/broadcast/java_broadcastapilistenerproxy.h"
#include "twitchsdk/broadcast/java_broadcastutil.h"
#include "twitchsdk/broadcast/java_ingesttesterlistenerproxy.h"
#include "twitchsdk/broadcast/passthroughvideoencoder.h"
#include "twitchsdk/core/stringutilities.h"

using namespace ttv;
using namespace ttv::broadcast;
using namespace ttv::binding::java;

JNIEXPORT void JNICALL Java_tv_twitch_test_BroadcastTest_Test_1IBroadcastAPIListener(
  JNIEnv* jEnv, jobject /*jThis*/, jobject jModule, jobject jListener) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  LoadAllUtilityJavaClassInfo(jEnv);
  LoadAllCoreJavaClassInfo(jEnv);
  LoadAllBroadcastJavaClassInfo(jEnv);

  {
    auto listener = std::make_shared<JavaBroadcastAPIListenerProxy>(jModule);
    listener->SetListener(jListener);

    listener->ModuleStateChanged(nullptr, IModule::State::Initialized, TTV_EC_SUCCESS);
    listener->BroadcastStateChanged(TTV_EC_SUCCESS, BroadcastState::StartingBroadcast);
    listener->BroadcastBandwidthWarning(TTV_EC_BROADCAST_ALIGN16_REQUIRED, 123456);
    listener->BroadcastFrameSubmissionIssue(TTV_EC_BROADCAST_AUDIO_BUFFER_TOO_BIG);

    StreamInfo streamInfo;
    streamInfo.previewImages.largeUrl = "https://static-cdn.jtvnw.net/previews-ttv/640x360.jpg";
    streamInfo.previewImages.mediumUrl = "https://static-cdn.jtvnw.net/previews-ttv/320x180.jpg";
    streamInfo.previewImages.smallUrl = "https://static-cdn.jtvnw.net/previews-ttv/80x45.jpg";
    streamInfo.previewImages.templateUrl = "https://static-cdn.jtvnw.net/previews-ttv/{width}x{height}.jpg";

    streamInfo.game = "game";
    streamInfo.averageFPS = 62.0079;
    streamInfo.streamId = 567890;
    streamInfo.archiveVideoId = 123456;
    streamInfo.delay = 100;
    streamInfo.viewerCount = 31502;
    streamInfo.videoHeight = 720;
    streamInfo.createdAtTimestamp = 135135;
    streamInfo.broadcastPlatform = BroadcastPlatform::PS4;
    streamInfo.streamType = StreamType::Live;
    streamInfo.isPlaylist = false;

    ChannelInfo& channelInfo = streamInfo.channelInfo;

    channelInfo.displayName = "displayName";
    channelInfo.name = "name";
    channelInfo.game = "game";
    channelInfo.description = "description - details";
    channelInfo.status = "status";
    channelInfo.language = "language";
    channelInfo.broadcasterLanguage = "broadcasterLanguage";
    channelInfo.logoImageUrl = "https://logoImageUrl.com";
    channelInfo.channelUrl = "https://channelUrl.com";
    channelInfo.videoBannerImageUrl = "https://videoBannerImageUrl.com";
    channelInfo.profileBannerImageUrl = "https://profileBannerImageUrl.com";
    channelInfo.channelId = 1234;
    channelInfo.createdAtTimestamp = 99999;
    channelInfo.updatedAtTimestamp = 88888;
    channelInfo.numFollowers = 1337;
    channelInfo.numViews = 31337;
    channelInfo.mature = true;
    channelInfo.partner = true;
    channelInfo.affiliate = false;

    listener->StreamInfoFetched(TTV_EC_SUCCESS, streamInfo);

    CanTheyError error;
    error.code = "error_code";
    error.message = "error_message";
    error.links = {"error_link_0", "error_link_1"};

    listener->StreamKeyError(error);
  }
}

JNIEXPORT void JNICALL Java_tv_twitch_test_BroadcastTest_Test_1IIngestTesterListener(
  JNIEnv* jEnv, jobject /*jThis*/, jobject /*jModule*/, jobject jListener) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  LoadAllUtilityJavaClassInfo(jEnv);
  LoadAllCoreJavaClassInfo(jEnv);
  LoadAllBroadcastJavaClassInfo(jEnv);

  {
    auto listener = std::make_shared<JavaIngestTesterListenerProxy>();
    listener->SetListener(jListener);

    listener->BroadcastIngestTesterStateChanged(nullptr);
  }
}

JNIEXPORT void JNICALL Java_tv_twitch_test_BroadcastTest_Test_1PassThroughVideoEncoder(
  JNIEnv* jEnv, jobject /*jThis*/, jobject jVideoEncoder) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  LoadAllUtilityJavaClassInfo(jEnv);
  LoadAllCoreJavaClassInfo(jEnv);
  LoadAllBroadcastJavaClassInfo(jEnv);

  auto instance = gPassThroughVideoEncoderInstanceRegistry.LookupNativeInstance(jVideoEncoder);
  instance->SetTargetBitRate(123456);
}

JNIEXPORT void JNICALL Java_tv_twitch_test_BroadcastTest_Test_1IBandwidthStatListener(
  JNIEnv* jEnv, jobject /*jThis*/, jobject /*jModule*/, jobject jListener) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  LoadAllUtilityJavaClassInfo(jEnv);
  LoadAllCoreJavaClassInfo(jEnv);
  LoadAllBroadcastJavaClassInfo(jEnv);

  {
    auto listener = std::make_shared<JavaBandwidthStatListenerProxy>();
    listener->SetListener(jListener);

    BandwidthStat stat;
    stat.recommendedBitsPerSecond = 7777;
    stat.measuredBitsPerSecond = 8888;
    stat.encoderOutputBitsPerSecond = 9999;

    stat.backBufferSeconds = 1.5;
    stat.congestionLevel = 0.4;
    stat.recordedTime = 4.5;

    listener->ReceivedBandwidthStat(stat);
  }
}
