##########################################################################################################
#
# Fragment: broadcast_lame-audio-encoder
#
##########################################################################################################

import os
import glob
import build_types
import build_tools

def load_twitchsdk_fragment(primitives, options):

    fragment = build_types.SourceFragment('twitchsdk', 'broadcast_lame-audio-encoder', os.path.dirname(os.path.realpath(__file__)))

    # Add source and header files
    build_tools.add_source_files_recursively(fragment, 'source', ['.cpp'], 'Source Files/broadcast/lame-audio-encoder')
    build_tools.add_source_files_recursively(fragment, 'include/twitchsdk/broadcast', ['.h'], 'Header Files/broadcast/lame-audio-encoder')

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include'), is_public=True )
    fragment.add_dependency_search_paths( os.path.join(fragment.root_path, '..', 'dependencies', 'libmp3lame', 'include') )

    # TODO: Remove this win32-specific reference
    fragment.add_link_libraries( os.path.join(fragment.root_path, '..', 'dependencies', 'libmp3lame', 'lib', options.architecture, 'libmp3lame-ttv.lib') )

    return fragment
