/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

// Graphics device identifiers in Unity
enum GfxDeviceRenderer {
  kGfxRendererOpenGL = 0,         // OpenGL
  kGfxRendererD3D9,               // Direct3D 9
  kGfxRendererD3D11,              // Direct3D 11
  kGfxRendererGCM,                // Sony PlayStation 3 GCM
  kGfxRendererNull,               // "null" device (used in batch mode)
  kGfxRendererHollywood,          // Nintendo Wii
  kGfxRendererXenon,              // Xbox 360
  kGfxRendererOpenGLES,           // OpenGL ES 1.1
  kGfxRendererOpenGLES20Mobile,   // OpenGL ES 2.0 mobile variant
  kGfxRendererMolehill,           // Flash 11 Stage3D
  kGfxRendererOpenGLES20Desktop,  // OpenGL ES 2.0 desktop variant (i.e. NaCl)
  kGfxRendererCount
};
