##########################################################################################################
#
# Fragment: broadcast_win32
#
##########################################################################################################

import os
import glob
import build_types
import build_tools

def load_twitchsdk_fragment(primitives, options):

    fragment = build_types.SourceFragment('twitchsdk', 'broadcast_win32', os.path.dirname(os.path.realpath(__file__)))

    # Preprocessor defines
    fragment.add_preprocessor_definition('TTV_BROADCAST_INCLUDE_PCH_PLATFORM')

    # Use custom implementation of certain C++11 features
    if options.compiler == "vs2010" or options.compiler == "vs2012":
        fragment.add_preprocessor_definition('TTV_INCLUDE_CPPTRANSITIONS')

    # Add source and header files
    build_tools.add_source_files_recursively(fragment, 'source', ['.cpp'], 'Source Files/broadcast/win32')
    build_tools.add_source_files_recursively(fragment, 'include/twitchsdk/broadcast', ['.h'], 'Header Files/broadcast/win32')

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )

    return fragment


def load_sample_fragment(sample_name, options):
    fragment = build_types.SampleSourceFragment(sample_name, 'broadcast_win32', os.path.dirname(os.path.realpath(__file__)))

    # Add source and header files
    build_tools.add_source_files_recursively(fragment, 'samples/' + sample_name + '/source', ['.cpp'], 'Source Files/broadcast/samples/' + sample_name + '/win32')
    build_tools.add_source_files_recursively(fragment, 'samples/' + sample_name + '/include/twitchsdk/broadcast', ['.h'], 'Header Files/broadcast/samples/' + sample_name + '/win32')

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'samples', sample_name, 'include') )

    return fragment
