/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/ivideoframereceiver.h"

#include <memory>

struct IDirect3DDeviceManager9;

namespace ttv {
namespace broadcast {
class ID3dDeviceManager9VideoFrameReceiver;
}
}  // namespace ttv

/**
 * Automatically captures frames from the D3D device.
 */
class ttv::broadcast::ID3dDeviceManager9VideoFrameReceiver : public IVideoFrameReceiver {
 public:
  virtual TTV_ErrorCode SetD3dDeviceManager(IDirect3DDeviceManager9* deviceManager) = 0;

  static const ReceiverTypeId GetReceiverTypeId() {
    static int typeId = 0;
    return reinterpret_cast<ReceiverTypeId>(&typeId);
  }
};
