/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/audiocapturebase.h"

namespace ttv {
namespace broadcast {
class WinAudioCapture;
class WinAudioCaptureInternalData;
}  // namespace broadcast
}  // namespace ttv

/**
 * An IAudioCapture implementation that can capture both system audio and microphone
 * audio from Windows.
 */
class ttv::broadcast::WinAudioCapture : public AudioCaptureBase {
 public:
  enum class CaptureType { System, Microphone };

 public:
  WinAudioCapture(CaptureType type);
  virtual ~WinAudioCapture();

 public:
  // IAudioCapture implementation
  virtual std::string GetName() const override;
  virtual uint32_t GetNumChannels() const override;
  virtual TTV_ErrorCode Start() override;
  virtual TTV_ErrorCode Stop() override;
  virtual TTV_ErrorCode Process(const std::shared_ptr<IAudioMixer>& mixer, uint64_t& lastSampleTime) override;

 private:
  TTV_ErrorCode SubmitSamples(void* samples, size_t sampleCount, uint64_t timestamp);

  std::unique_ptr<WinAudioCaptureInternalData> mInternalData;
};
