/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/testwindesktopvideocapturer.h"

#include "twitchsdk/core/assertion.h"

#include <windows.h>

std::string ttv::broadcast::test::TestWinDesktopVideoCapturer::GetName() const {
  return "TestWinDesktopVideoCapturer";
}

void ttv::broadcast::test::TestWinDesktopVideoCapturer::GenerateFrame(
  uint8_t* buffer, PixelFormat& pixelFormat, bool& requiresVerticalFlip) {
  pixelFormat = PixelFormat::TTV_PF_BGRA;
  requiresVerticalFlip = false;

  HWND hwnd = GetDesktopWindow();
  RECT rcClient;
  GetClientRect(hwnd, &rcClient);
  POINT topLeft = {rcClient.left, rcClient.top};
  POINT bottomRight = {rcClient.right, rcClient.bottom};
  ClientToScreen(hwnd, &topLeft);
  ClientToScreen(hwnd, &bottomRight);

  int srcHeight = bottomRight.y - topLeft.y;
  int srcWidth = bottomRight.x - topLeft.x;

  int bitmapBufferSize = mVideoParams.outputWidth * mVideoParams.outputHeight * 4;

  HDC hDC = GetDC(hwnd);
  TTV_ASSERT(hDC);

  HDC hCaptureDC = CreateCompatibleDC(hDC);
  TTV_ASSERT(hCaptureDC);

  HBITMAP hCaptureBitmap = CreateCompatibleBitmap(hDC, mVideoParams.outputWidth, mVideoParams.outputHeight);
  TTV_ASSERT(hCaptureBitmap);

  HBITMAP hOldBitmap = (HBITMAP)SelectObject(hCaptureDC, hCaptureBitmap);
  TTV_ASSERT(hOldBitmap);

  SetStretchBltMode(hCaptureDC, HALFTONE);

  StretchBlt(
    hCaptureDC, 0, 0, mVideoParams.outputWidth, mVideoParams.outputHeight, hDC, 0, 0, srcWidth, srcHeight, SRCCOPY);

  GetBitmapBits(hCaptureBitmap, bitmapBufferSize, buffer);

  SelectObject(hCaptureDC, hOldBitmap);
  DeleteObject(hCaptureBitmap);
  DeleteDC(hCaptureDC);
  ReleaseDC(hwnd, hDC);
}
