#include "IAMF0Encoder.h"

#include "StdAfx.h"

IAMF0Encoder::IAMF0Encoder(void) {}

IAMF0Encoder::~IAMF0Encoder(void) {}

template <typename _T>
void IAMF0Encoder::EncodeToBuffer(_T param) {
  auto p = reinterpret_cast<uint8_t*>(&param);

  for (int i = sizeof(_T) - 1; i >= 0; --i) {
    mBuffer.push_back(p[i]);
  }
}

void IAMF0Encoder::Number(double value) {
  mBuffer.push_back(number);
  EncodeToBuffer(value);
}

void IAMF0Encoder::Boolean(bool flag) {
  mBuffer.push_back(boolean);
  mBuffer.push_back(flag ? 1 : 0);
}

void IAMF0Encoder::String(std::string param) {
  mBuffer.push_back(string);
  EncodeToBuffer(static_cast<int16_t>(param.length()));
  mBuffer.insert(mBuffer.end(), param.begin(), param.end());
}

void IAMF0Encoder::Object() {
  mBuffer.push_back(object);
}

void IAMF0Encoder::ObjectProperty(std::string propertyName) {
  EncodeToBuffer(static_cast<int16_t>(propertyName.length()));
  mBuffer.insert(mBuffer.end(), propertyName.begin(), propertyName.end());
}

void IAMF0Encoder::Movieclip() {
  assert(false && "unsupported");
}

void IAMF0Encoder::Null() {
  assert(false && "unsupported");
  mBuffer.push_back(null);
}

void IAMF0Encoder::Undefined() {
  assert(false && "unsupported");
}

void IAMF0Encoder::Reference() {
  assert(false && "unimplemented");
}

void IAMF0Encoder::EcmaArray(uint32_t elements) {
  mBuffer.push_back(ecmaArray);
  EncodeToBuffer(elements);
}

void IAMF0Encoder::EcmaArrayKey(std::string keyName) {
  EncodeToBuffer(static_cast<int16_t>(keyName.length()));
  mBuffer.insert(mBuffer.end(), keyName.begin(), keyName.end());
}
void IAMF0Encoder::ObjectEnd() {
  mBuffer.push_back(0);
  mBuffer.push_back(0);
  mBuffer.push_back(objectEnd);
}

void IAMF0Encoder::StrictArray(uint32_t elements) {
  mBuffer.push_back(strictArray);
  EncodeToBuffer(elements);
}

void IAMF0Encoder::Date(double dateValue) {
  mBuffer.push_back(date);
  uint16_t timezone = 0;  // spec says always 0
  EncodeToBuffer(dateValue);
  EncodeToBuffer(timezone);
}

void IAMF0Encoder::LongString() {
  assert(false && "unimplemented");
}

void IAMF0Encoder::Unsupported() {
  assert(false && "unsupported");
}

void IAMF0Encoder::Recordset() {
  assert(false && "unimplemented");
}

void IAMF0Encoder::XmlDocument() {
  assert(false && "unimplemented");
}

void IAMF0Encoder::TypedObject() {
  assert(false && "unimplemented");
}
