#ifndef IAMF0ENCODER_H
#define IAMF0ENCODER_H

#include "amf0.h"

#include <vector>

class IAMF0Encoder : public IAMF0 {
 public:
  IAMF0Encoder(void);
  virtual ~IAMF0Encoder(void);

  virtual void Number(double value);
  virtual void Boolean(bool flag);
  virtual void String(std::string param);
  virtual void Object();
  virtual void ObjectProperty(std::string propertyName);
  virtual void Movieclip();
  virtual void Null();
  virtual void Undefined();
  virtual void Reference();
  virtual void EcmaArray(uint32_t elements);
  virtual void EcmaArrayKey(std::string keyName);
  virtual void ObjectEnd();
  virtual void StrictArray(uint32_t elements);
  virtual void Date(double dateValue);
  virtual void LongString();
  virtual void Unsupported();
  virtual void Recordset();
  virtual void XmlDocument();
  virtual void TypedObject();

  const std::vector<uint8_t>& GetBuffer() const { return mBuffer; }

 private:
  template <typename _T>
  void EncodeToBuffer(_T param);
  std::vector<uint8_t> mBuffer;
};

#endif
