#ifndef FLVFORMAT_H
#define FLVFORMAT_H

namespace flv {
struct Header;
struct TagHeader;
struct TagFooter;

enum class TagTypes : uint8_t { Audio = 0x08, Video = 0x09, Meta = 0x12 };
}  // namespace flv

typedef uint8_t uint24_t[3];

uint32_t BigToLittle(uint32_t source) {
  uint32_t target = 0;

  auto pSource = reinterpret_cast<uint8_t*>(&source);
  auto pTarget = reinterpret_cast<uint8_t*>(&target);
  pTarget[0] = pSource[3];
  pTarget[1] = pSource[2];
  pTarget[2] = pSource[1];
  pTarget[3] = pSource[0];

  return target;
}

uint32_t BigToLittle(uint24_t source) {
  uint32_t target = 0;

  auto pTarget = reinterpret_cast<uint8_t*>(&target);
  pTarget[0] = source[2];
  pTarget[1] = source[1];
  pTarget[2] = source[0];

  return target;
}

#pragma pack(push)
#pragma pack(1)

struct flv::Header {
  uint24_t mSigniture;
  uint8_t umVersion;
  uint8_t mFlags;
  uint32_t mHeaderSize;
};

struct flv::TagHeader {
  TagTypes mPacketType;
  uint24_t mPacketLength;
  uint24_t mPacketTimestamp;
  uint8_t mPacketExtendedTimestamp;
  uint24_t mStreamId;
};

struct flv::TagFooter {
  uint32_t mLength;  // Should be TagHeader.mPacketLength + sizeof (flv::TagHeader);
};

#pragma pack(pop)

#endif
