// mp4dump.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <bitset>
#include <iomanip>
#include <iostream>
#include <iterator>

using namespace std;

const int kTabSize = 3;

vector<uint8_t> readFile(string filename) {
  cout << filename << endl;
  std::vector<uint8_t> ret;

  auto inputFile = fopen(filename.c_str(), "rb");
  if (inputFile) {
    fseek(inputFile, 0, SEEK_END);
    auto size = ftell(inputFile);
    cout << size;
    fseek(inputFile, 0, SEEK_SET);

    ret.resize(size);
    fread(ret.data(), size, 1, inputFile);
    fclose(inputFile);
  }
  cout << endl;
  return ret;
}

uint32_t FlipEndian(uint32_t in) {
  union {
    uint32_t U32;
    uint8_t U8[4];
  } out;
  out.U32 = in;

  swap(out.U8[0], out.U8[3]);
  swap(out.U8[1], out.U8[2]);

  return out.U32;
}

int32_t FlipEndian(int32_t in) {
  union {
    int32_t I32;
    uint8_t U8[4];
  } out;
  out.I32 = in;

  swap(out.U8[0], out.U8[3]);
  swap(out.U8[1], out.U8[2]);

  return out.I32;
}

struct atomHeader_t {
  uint32_t atomLength;
  uint32_t atomName;
};

struct encodedPixelDimensions_t {
  uint32_t versionAndFlags;  // 1 byte for version, 3 for flags
  uint32_t width;
  uint32_t height;
};

struct stsdAtom_t {
  uint32_t versionAndFlags;  // 1 byte for version, 3 for flags
  uint32_t numEntries;
};

struct elstAtom_t {
  uint32_t versionAndFlags;  // 1 byte for version, 3 for flags
  uint32_t numEntries;
};

struct stszAtom_t {
  uint32_t versionAndFlags;  // 1 byte for version, 3 for flags
  uint32_t sampleSize;
  uint32_t numEntries;
  uint32_t firstEntry;
};

struct sdtpAtom_t {
  uint32_t versionAndFlags;  // 1 byte for version, 3 for flags
  uint8_t firstEntry;
};

struct sttsAtom_t {
  uint32_t versionAndFlags;  // 1 byte for version, 3 for flags
  uint32_t numEntries;
  struct entry_t {
    uint32_t sampleCount;
    uint32_t duration;
  } firstEntry;
};

struct cttsAtom_t {
  uint32_t versionAndFlags;  // 1 byte for version, 3 for flags
  uint32_t numEntries;
  struct entry_t {
    uint32_t sampleCount;
    int32_t offset;
  } firstEntry;
};

struct mvhdAtom_t {
  uint32_t versionAndFlags;  // 1 byte for version, 3 for flags
  uint32_t creationTime;
  uint32_t modificationTime;
  uint32_t timeScale;
  uint32_t duration;
  uint32_t preferredRate;
  uint16_t preferredVolume;
  uint8_t reserved[10];
  uint32_t matrix[9];
  uint32_t previewTime;
  uint32_t previewDuration;
  uint32_t posterTime;
  uint32_t selectionTime;
  uint32_t selectionDuration;
  uint32_t currentTime;
  uint32_t nextTrackID;
};

bool IsLeafAtom(uint32_t name) {
  switch (name) {
    case 'moov':
    case 'trak':
    case 'tapt':
    case 'edts':
    case 'mdia':
    case 'minf':
    case 'stbl':
      return false;
  }
  return true;
}

std::vector<uint8_t>::iterator ParseAtom(std::vector<uint8_t>::iterator it, int depth = 0) {
  auto header = reinterpret_cast<atomHeader_t*>(&*it);
  auto length = FlipEndian(header->atomLength);
  auto name = FlipEndian(header->atomName);
  auto typeChar = reinterpret_cast<char*>(&name);
  it += 8;

  fill_n(ostream_iterator<char>(cout), kTabSize * depth, ' ');

  int line = 0;

  cout << typeChar[3] << typeChar[2] << typeChar[1] << typeChar[0] << " , " << length;
  switch (name) {
    case 'ftyp':
      cout << " File Type " << &*it;
      break;
    case 'clef':
    case 'prof':
    case 'enof': {
      auto dimensions = reinterpret_cast<encodedPixelDimensions_t*>(&*it);
      cout << " " << FlipEndian(dimensions->width) << "x" << FlipEndian(dimensions->height);
    } break;
    case 'mvhd': {
      auto movieHeader = reinterpret_cast<mvhdAtom_t*>(&*it);
      cout << " " << FlipEndian(movieHeader->timeScale) << " " << FlipEndian(movieHeader->duration) << " "
           << FlipEndian(movieHeader->duration) / FlipEndian(movieHeader->timeScale);
    } break;
    case 'elst': {
      auto entryList = reinterpret_cast<elstAtom_t*>(&*it);
      cout << " " << FlipEndian(entryList->numEntries) << " entries";
    } break;
    case 'stsd': {
      auto entryList = reinterpret_cast<stsdAtom_t*>(&*it);
      cout << " " << FlipEndian(entryList->numEntries) << " entries";
    } break;
    case 'ctts': {
      auto entryList = reinterpret_cast<cttsAtom_t*>(&*it);
      cout << " " << FlipEndian(entryList->numEntries) << " entries";
      auto sampleList = &entryList->firstEntry;

      for (uint32_t i = 0; i < FlipEndian(entryList->numEntries); ++i) {
        if ((i % 6) == 0) {
          cout << endl;
          ;
          fill_n(ostream_iterator<char>(cout), kTabSize * (depth + 1), ' ');
          cout << line++ << ": ";
        }
        cout << FlipEndian(sampleList[i].sampleCount) << "," << FlipEndian(sampleList[i].offset) << " ";
      }
    } break;
    case 'stsz': {
      auto entryList = reinterpret_cast<stszAtom_t*>(&*it);
      cout << " " << FlipEndian(entryList->sampleSize) << " defaultSize";
      cout << " " << FlipEndian(entryList->numEntries) << " entries";
      auto sampleList = &entryList->firstEntry;

      for (uint32_t i = 0; i < FlipEndian(entryList->numEntries); ++i) {
        if ((i % 6) == 0) {
          cout << endl;
          ;
          fill_n(ostream_iterator<char>(cout), kTabSize * (depth + 1), ' ');
          cout << line++ << ": ";
        }
        cout << setw(8) << left << FlipEndian(sampleList[i]);
      }
    } break;
    case 'stts': {
      auto entryList = reinterpret_cast<sttsAtom_t*>(&*it);
      cout << " " << FlipEndian(entryList->numEntries) << " entries";
      auto sampleList = &entryList->firstEntry;

      for (uint32_t i = 0; i < FlipEndian(entryList->numEntries); ++i) {
        if ((i % 6) == 0) {
          cout << endl;
          ;
          fill_n(ostream_iterator<char>(cout), kTabSize * (depth + 1), ' ');
          cout << line++ << ": ";
        }
        cout << FlipEndian(sampleList[i].duration) << " " << FlipEndian(sampleList[i].sampleCount) << " ";
      }
    } break;
    case 'sdtp': {
      auto entryList = reinterpret_cast<sdtpAtom_t*>(&*it);
      auto sampleList = &entryList->firstEntry;

      for (uint32_t i = 0; i < length - (sizeof 5 + 8); ++i) {
        if ((i % 6) == 0) {
          cout << endl;
          ;
          fill_n(ostream_iterator<char>(cout), kTabSize * (depth + 1), ' ');
          cout << line++ << ": ";
        }
        cout << to_string(sampleList[i]) << " ";
      }
    } break;
  }

  cout << endl;

  auto itChild = it;
  it += (length - 8);

  while (itChild != it && length > 8 && IsLeafAtom(name) == false) {
    itChild = ParseAtom(itChild, depth + 1);
  }

  return it;
}

int main(int argc, char* argv[]) {
  cout << argv[0] << endl;
  //  auto data = readFile ("sample_iPod.m4v");

  std::string filename = "";
  if (argc == 2) {
    filename = argv[1];
  }
  auto data = readFile(filename);
  if (data.size() == 0) {
    cout << "File not found!" << endl;
    return -1;
  }

  auto it = data.begin();

  do {
    it = ParseAtom(it);
  } while (it != data.end());

  system("pause");
  return 0;
}
