/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class IBitsListener;
}
}  // namespace ttv

/**
 * The listener interface for events from a BitsStatus implementation.
 */
class ttv::chat::IBitsListener {
 public:
  virtual ~IBitsListener() = default;

  /**
   * Called when a viewer cheers bits to the associated channel.
   * @param[in] bitsReceivedEvent The details about the bits cheering received event.
   */
  virtual void UserReceivedBits(const BitsReceivedEvent& bitsReceivedEvent) = 0;

  /**
   * Called when the associated user cheers bits in a channel.
   * @param[in] bitsSentEvent The details about the bits cheering sent event.
   */
  virtual void UserSentBits(const BitsSentEvent& bitsSentEvent) = 0;

  /**
   * Called when a user's bits balance increases, from buying bits or from watching ads.
   * @param[in] bitsBalance The new bits balance of the user.
   */
  virtual void UserGainedBits(const uint32_t bitsBalance) = 0;
};
