/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class IBitsStatus;
}
}  // namespace ttv

/**
 * The interface for receiving bits updates on a channel.
 */
class ttv::chat::IBitsStatus {
 public:
  virtual ~IBitsStatus() = default;

  /**
   * Is BitsStatus ready to receive Pub Sub notifications
   */
  virtual bool IsReady() const = 0;

  /**
   * This should be called when the application is done with the instance.
   */
  virtual TTV_ErrorCode Dispose() = 0;
};
