/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

#include <memory>

namespace ttv {
namespace chat {
class IChatChannel;
}
}  // namespace ttv

/**
 * The interface for connecting to a live chat channel.
 */
class ttv::chat::IChatChannel {
 public:
  using SetBroadcasterLanguageChatEnabledCallback = std::function<void(TTV_ErrorCode ec)>;
  using FetchUserListCallback = std::function<void(TTV_ErrorCode ec, UserList&& userList)>;

 public:
  virtual ~IChatChannel();

  /**
   * This should be called when the application is done with the instance.
   */
  virtual void Dispose() = 0;

  virtual TTV_ErrorCode Connect() = 0;
  virtual TTV_ErrorCode Disconnect() = 0;
  virtual TTV_ErrorCode SendMessage(const std::string& message) = 0;

  virtual TTV_ErrorCode FetchUserList(const FetchUserListCallback& callback) = 0;
  virtual uint64_t GetRemainingSlowModeTime() = 0;
};
