/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class IChatRaidListener;
}
}  // namespace ttv

/**
 * The listener interface for events from an IChatRaid implementation.
 */
class ttv::chat::IChatRaidListener {
 public:
  virtual ~IChatRaidListener() = default;

  /**
   * Indicates that a raid has been started on the associated channel.
   *
   * @param[out]: status The details about the raid.
   */
  virtual void RaidStarted(const RaidStatus& status) = 0;

  /**
   * Indicates that there has been a change in the state of the raid.
   * This is primarily used to update the number of users in the raid.
   *
   * @param[out]: status The details about the raid.
   */
  virtual void RaidUpdated(const RaidStatus& status) = 0;

  /**
   * Indicates that the raid has been fired and the client should transition to the target channel.
   *
   * @param[out]: status The details about the raid.
   */
  virtual void RaidFired(const RaidStatus& status) = 0;

  /**
   * Indicates that the raid has been cancelled and the client should NOT transition to the target channel.
   *
   * @param[out]: status The details about the raid.
   */
  virtual void RaidCancelled(const RaidStatus& status) = 0;
};
