/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class IChatRoomListener;
}
}  // namespace ttv

/**
 * Listener interface for unsolicited events from IChatRoom.
 */
class ttv::chat::IChatRoomListener {
 public:
  virtual ~IChatRoomListener() = default;

  /**
   * Called when a new message is received.
   *
   * @param[in] roomId The id of the room the message was sent to.
   * @param[in] message The message that was received.
   */
  virtual void MessageReceived(const std::string& roomId, ChatRoomMessage&& message) = 0;

  /**
   * Called when another user's old message is edited.
   *
   * @param[in] roomId The id of the room that owns the edited message.
   * @param[in] message The message that was edited.
   */
  virtual void MessageEdited(const std::string& roomId, ChatRoomMessage&& message) = 0;

  /**
   * Called when another user's old message is deleted.
   *
   * @param[in] roomId The id of the room that owns the deleted message.
   * @param[in] message The message that was deleted.
   */
  virtual void MessageDeleted(const std::string& roomId, ChatRoomMessage&& message) = 0;

  /**
   * Called the chat room's information is changed.
   * Returned object fields "view" and "owner" are invalid data.
   *
   * @param[in] roomInfo The newly updated information of the room.
   */
  virtual void RoomUpdated(ChatRoomInfo&& roomInfo) = 0;
};
