/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class IFollowersListener;
}
}  // namespace ttv

/**
 * The listener interface for events from a FollowersStatus implementation.
 */
class ttv::chat::IFollowersListener {
 public:
  virtual ~IFollowersListener() = default;

  /**
   * Called when a new follower added event occurs on the associated channel.
   * @param[in]: followerAddedEvent The details about the new follower.
   */
  virtual void NewFollowerAdded(const FollowerAddedEvent& followerAddedEvent) = 0;
};
