/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class IFollowingListener;
}
}  // namespace ttv

/**
 * The listener interface for when the current user follows/unfollows other channels.
 */
class ttv::chat::IFollowingListener {
 public:
  virtual ~IFollowingListener() = default;

  /**
   * Called when the current user follows another channel.
   * @param[in]: userId The current user's ID.
   * @param[in]: channelId The channel that the user followed.
   */
  virtual void FollowedChannel(UserId userId, ChannelId channelId) = 0;

  /**
   * Called when the current user unfollows another channel.
   * @param[in]: userId The current user's ID.
   * @param[in]: channelId The channel that the user unfollowed.
   */
  virtual void UnfollowedChannel(UserId userId, ChannelId channelId) = 0;
};
