/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"

namespace ttv {
namespace chat {
class IMultiviewNotificationsListener;
}
}  // namespace ttv

/**
 * Listener interface for chanages to a multi-view stream.
 */
class ttv::chat::IMultiviewNotificationsListener {
 public:
  virtual ~IMultiviewNotificationsListener() = default;

  /**
   * Called when a chanlet of the multi-view stream updates.
   *
   * @param[in] userId The id of the current user.
   * @param[in] channelId The multi-view channel.
   * @param[in] chanlet The chanlet that was updated.
   */
  virtual void ChanletUpdated(UserId userId, ChannelId channelId, Chanlet&& chanlet) = 0;
};
