/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/ibitsstatus.h"
#include "twitchsdk/chat/internal/bitsconfigrepository.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"

namespace ttv {
namespace chat {
class IBitsListener;
class BitsStatus;
}  // namespace chat
}  // namespace ttv

/**
 * A concrete implemenation of IBitsStatus.
 */
class ttv::chat::BitsStatus : public ttv::PubSubComponent<IBitsListener>, public IBitsStatus {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  BitsStatus(const std::shared_ptr<User>& user);

  static std::string GetComponentName() { return "ttv::BitsStatus"; }
  virtual std::string GetLoggerName() const override;

  virtual TTV_ErrorCode Initialize() override;
  virtual bool CheckShutdown() override;
  virtual TTV_ErrorCode Shutdown() override;
  virtual void Update() override;

  // IBitsStatus Implementation
  virtual TTV_ErrorCode Dispose() override;
  virtual bool IsReady() const override;

  void SetTokenizationOptions(const TokenizationOptions& tokenizationOptions) {
    mTokenizationOptions = tokenizationOptions;
  }
  void SetBitsConfigRepository(const std::shared_ptr<BitsConfigRepository>& bitsConfigRepository) {
    mBitsConfigRepository = bitsConfigRepository;
  }

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const json::Value& msg) override;

 private:
  void ParseBitsReceivedMessage(const ttv::json::Value& jBitsMessage, BitsReceivedEvent& event);
  TTV_ErrorCode FetchBitsConfig();

  std::shared_ptr<BitsConfigRepository> mBitsConfigRepository;
  std::shared_ptr<BitsConfiguration> mBitsConfiguration;

  RetryTimer mFetchBitsConfigRetryTimer;

  std::string mChannelBitsPubSubTopic;
  std::string mUserBitsPubSubTopic;
  TokenizationOptions mTokenizationOptions;
  BitsConfigRepository::LookupId mBitsConfigFetchToken;  //!< The cancellation token for fetching the BitsConfiguration.
  ChannelId mChannelId;
  bool mHasFetchedBitsConfig;
};
