/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/ifollowersstatus.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"

namespace ttv {
namespace chat {
class IFollowersListener;
class FollowersStatus;
}  // namespace chat
}  // namespace ttv

/**
 * A concrete implemenation of IFollowersStatus.
 */
class ttv::chat::FollowersStatus : public ttv::PubSubComponent<IFollowersListener>, public IFollowersStatus {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  FollowersStatus(const std::shared_ptr<User>& user, ChannelId channelId);

  static std::string GetComponentName() { return "ttv::FollowersStatus"; }
  virtual std::string GetLoggerName() const override;

  // IFollowersStatus Implementation
  virtual TTV_ErrorCode Dispose() override;

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const json::Value& msg) override;

 private:
  std::string mPubSubTopic;
};
