/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/ifollowingstatus.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"

namespace ttv {
namespace chat {
class IFollowingListener;
class FollowingStatus;
}  // namespace chat
}  // namespace ttv

/**
 * A concrete implemenation of IFollowingStatus.
 */
class ttv::chat::FollowingStatus : public ttv::PubSubComponent<IFollowingListener>, public IFollowingStatus {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  FollowingStatus(const std::shared_ptr<User>& user);

  static std::string GetComponentName() { return "ttv::chat::FollowingStatus"; }
  virtual std::string GetLoggerName() const override;

  // IFollowersStatus Implementation
  virtual TTV_ErrorCode Dispose() override;

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const json::Value& msg) override;

 private:
  std::string mPubSubTopic;
};
