/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/isubscribersstatus.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"

namespace ttv {
namespace chat {
class ISubscribersListener;
class SubscribersStatus;
}  // namespace chat
}  // namespace ttv

/**
 * A concrete implemenation of ISubscribersStatus.
 */
class ttv::chat::SubscribersStatus : public ttv::PubSubComponent<ISubscribersListener>, public ISubscribersStatus {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  SubscribersStatus(const std::shared_ptr<User>& user);

  static std::string GetComponentName() { return "ttv::SubscribersStatus"; }
  virtual std::string GetLoggerName() const override;

  // ISubscribersStatus Implementation
  virtual TTV_ErrorCode Dispose() override;

  void SetTokenizationOptions(const TokenizationOptions& tokenizationOptions) {
    mTokenizationOptions = tokenizationOptions;
  }

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const json::Value& msg) override;

 private:
  void ParseSubscriptionMessage(const ttv::json::Value& jSubMessage, SubscriberAddedEvent& event);

  std::string mPubSubTopic;
  TokenizationOptions mTokenizationOptions;
};
