/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/ichannelchatroommanager.h"
#include "twitchsdk/chat/ichannelchatroommanagerlistener.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"

namespace ttv {
namespace chat {
class ChannelChatRoomManager;
}
}  // namespace ttv

class ttv::chat::ChannelChatRoomManager : public IChannelChatRoomManager,
                                          public PubSubComponent<IChannelChatRoomManagerListener> {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  ChannelChatRoomManager(const std::shared_ptr<User>& user, ChannelId channelId);

  // Component Overrides
  static std::string GetComponentName() { return "ttv::chat::ChannelChatRoomManager"; }
  virtual std::string GetLoggerName() const override;

  // IChannelChatRoomManager implementation
  virtual TTV_ErrorCode Dispose() override;
  virtual TTV_ErrorCode AddNewChatRoom(const std::string& roomName, const std::string& topic,
    RoomRolePermissions permissions, const AddRoomCallback& callback) override;
  virtual TTV_ErrorCode JoinChatRooms(const JoinCallback& callback) override;
  virtual TTV_ErrorCode LeaveChatRooms(const LeaveCallback& callback) override;
  virtual TTV_ErrorCode FetchChatRoomsInfo(const FetchRoomsInfoCallback& callback) override;

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const ttv::json::Value& jVal) override;

 private:
  std::string mPubSubTopic;
  UserId mUserId;
  ChannelId mChannelId;
};
