/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/ichatchannelproperties.h"
#include "twitchsdk/chat/ichatchannelpropertylistener.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"
#include "twitchsdk/core/timer.h"
#include "twitchsdk/core/user/user.h"

namespace ttv {
namespace chat {
class ChatChannelProperties;
}
}  // namespace ttv

class ttv::chat::ChatChannelProperties : public IChatChannelProperties,
                                         public PubSubComponent<IChatChannelPropertyListener> {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  /**
   * HostingInfo - Information about a channel's host.
   */
  struct HostingInfo {
    HostingInfo();
    //!< The name of the channel who is doing the hosting.
    std::string hostChannelName;
    //!< The name of the channel now being hosted. Will be empty if we are now no longer hosting.
    std::string targetChannelName;
    //!< The id of the channel who is doing the hosting.
    ChannelId hostChannelId;
    //!< The channel id of the channel now being hosted. Will be 0 if we are now no longer hosting.
    ChannelId targetChannelId;
    //!< The id of the channel previously being hosted. Will be 0 if we were not hosting before.
    ChannelId previousTargetChannelId;
    //!< The number of viewers in the channel doing the hosting.
    uint32_t numViewers;
  };

  ChatChannelProperties(const std::shared_ptr<User>& user, ChannelId channelId);

  // Component Overrides
  static std::string GetComponentName() { return "ttv::chat::ChatChannelProperties"; }
  virtual std::string GetLoggerName() const override;

  virtual TTV_ErrorCode Initialize() override;
  virtual void Update() override;

  // IChatChannelProperties implementation
  virtual TTV_ErrorCode Dispose() override;

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const ttv::json::Value& jVal) override;

 private:
  void HandleInitChatRestrictions();

  std::string mPubSubTopic;
  ChannelId mChannelId;
  RetryTimer mFetchRetryTimer;
  bool areChatRestrictionsInitialized;
};
