/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/json/forwards.h"
#include "twitchsdk/core/mutex.h"
#include "twitchsdk/core/timer.h"
#include "twitchsdk/core/types/coretypes.h"

#include <array>
#include <queue>
#include <string>

namespace ttv {
namespace chat {
class ChatMessagePacer;

Color GetRandomUserColor(const std::string& username);
UserMode ParseUserType(const std::string& str);

// Helper function to parse the emoticon id from json objects.  The json key can be either string or integer value
bool ParseEmoticonId(const ttv::json::Value& data, const std::string& key, std::string& out);

// Helper function to unescape emoticon tokens received from back-end. Required since the server is escaping the JSON
// data as HTML.
void UnescapeEmoticonToken(std::string& token);

// Helper function to sort emiticonId
bool CompareEmoticonId(const std::string& lhs, const std::string& rhs);

}  // namespace chat
}  // namespace ttv

class ttv::chat::ChatMessagePacer {
 public:
  ChatMessagePacer();
  bool TrackMessage();
  void Clear();

 private:
  // Twitch is currently set to blacklist if the client sends more than 20 messages in 30 seconds but we'll be
  // conservative here.
  static const uint kMessagePacingWindowSize = 18;
  static const uint kMessagePacingTimeSpanSeconds = 30;

  std::array<uint64_t, kMessagePacingWindowSize>
    mMessageSubmissionTimes;  //!< The ring buffer of timestamps for the last n messages submitted.  This is used for preventing the client from submitting too many too quickly and becoming blacklisted.
  uint mNextMessageSubmissionIndex;  //!< The index of the next entry to write in mMessageSubmissionTimes.
};
