/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/ichatraid.h"
#include "twitchsdk/chat/ichatraidlistener.h"
#include "twitchsdk/core/component.h"
#include "twitchsdk/core/eventsource.h"
#include "twitchsdk/core/pubsub/pubsubclient.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"

#include <unordered_set>

namespace ttv {
class TaskRunner;
class ChannelRepository;

namespace chat {
class ChatRaid;
}
}  // namespace ttv

/**
 * A concrete implemenation of IChatRaid.
 */
class ttv::chat::ChatRaid : public PubSubComponent<IChatRaidListener>, public IChatRaid {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  ChatRaid(const std::shared_ptr<User>& user, ChannelId sourceChannelId);

  // Component Overrides
  static std::string GetComponentName() { return "ttv::ChatRaid"; }
  virtual std::string GetLoggerName() const override;

  // IChatRaid Implementation
  virtual TTV_ErrorCode Dispose() override;
  virtual TTV_ErrorCode Join(const std::string& raidId, const JoinCallback& callback) override;
  virtual TTV_ErrorCode Leave(const std::string& raidId, const LeaveCallback& callback) override;
  virtual TTV_ErrorCode Start(UserId targetUserId, const StartCallback& callback) override;
  virtual TTV_ErrorCode RaidNow(const RaidNowCallback& callback) override;
  virtual TTV_ErrorCode Cancel(const CancelCallback& callback) override;

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const json::Value& msg) override;

 private:
  // Component overrides
  virtual void CompleteShutdown() override;

  void HandleRaidStatus(RaidStatus& status, const std::string& eventType);

  std::unordered_map<std::string, RaidStatus> mActiveRaids;  // The currently active raids.
  std::unordered_set<std::string> mCompletedRaids;           // IDs of completed raids, to avoid race conditions.
  std::string mPubSubTopic;
  ChannelId mSourceChannelId;
};
