/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#ifndef TTVSDK_CHATREADER_H
#define TTVSDK_CHATREADER_H

#include "twitchsdk/chat/ichattransport.h"
#include "twitchsdk/chat/internal/chatnetworkevent.h"

namespace ttv {
namespace chat {
class ChatReader;
}
}  // namespace ttv

/**
 * Takes lines received from the transport and parses them.
 */
class ttv::chat::ChatReader : public IChatTransportReader {
 public:
  ChatReader();
  ~ChatReader();

  /**
   * Sets the event notifier instance to use for sending events.
   */
  inline void SetNotifySink(IChatReceiveNetworkEvent* pNotify) { mNotify = pNotify; }

  // IChatTransportReader implementation
  virtual void OnConnect(TTV_ErrorCode err, const char* error);
  virtual void OnError(TTV_ErrorCode err);
  virtual void OnClose();
  virtual void OnRead(const char* pData, size_t nSize);

  /**
   * Parses the given IRC line and acts upon the content, producing events if needed.
   */
  void OnLineRead(const char* line);

 private:
  /**
   * Parses the given IRC line and populates the event structure.
   */
  bool ParseEvent(ChatNetworkEvent& evt, const char* line);

  IChatReceiveNetworkEvent* mNotify;  //!< The component to notify when a line is successfully read.
  uint32_t mLineLength;               //!< The number of characters in the line buffer.
  std::vector<char>
    mLineBuffer;  //!< The scratch buffer which may store a partial line between reads from the transport.
  char mParseBuffer[IChatTransport::kMaxBufferSize];  //!< A scratch buffer for parsing lines.
};

#endif  // TTVSDK_CHATREADER_H
