/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/ichatroomnotifications.h"
#include "twitchsdk/chat/ichatroomnotificationslistener.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"
#include "twitchsdk/core/user/user.h"

namespace ttv {
namespace chat {
class ChatRoomNotifications;
}
}  // namespace ttv

class ttv::chat::ChatRoomNotifications : public IChatRoomNotifications,
                                         public PubSubComponent<IChatRoomNotificationsListener> {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  ChatRoomNotifications(const std::shared_ptr<User>& user);

  // Component Overrides
  static std::string GetComponentName() { return "ttv::chat::ChatRoomNotifications"; }
  virtual std::string GetLoggerName() const override;

  // IChatRoomNotifications implementation
  virtual TTV_ErrorCode Dispose() override;

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const ttv::json::Value& jVal) override;

 private:
  std::string mPubSubTopic;
  UserId mUserId;
};
