/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/ichattransport.h"
#include "twitchsdk/core/socket.h"

namespace ttv {
namespace chat {
class ChatSocketTransport;
}
}  // namespace ttv

/**
 * An implementation of a transport which handles sending and receiving data over a TCP socket.
 */
class ttv::chat::ChatSocketTransport : public IChatTransport {
 public:
  ChatSocketTransport();
  virtual ~ChatSocketTransport();

  // IChatTransport
  virtual TTV_ErrorCode Connect(const std::string& uri);                /* Connects to the transport. */
  virtual TTV_ErrorCode Close();                                        /* Closes the transport. */
  virtual bool IsOpen();                                                /* Whether or not the socket is open. */
  virtual void SetReader(std::shared_ptr<IChatTransportReader> reader); /* Sets the reader. */
  virtual TTV_ErrorCode ProcessIncomingEvent(bool& handled);    /* Attempts to read a single message from the socket. */
  virtual TTV_ErrorCode Write(const char* pData, size_t nSize); /* Writes the given data to the socket. */

  static TTV_ErrorCode CheckFactoryAvailability(const std::string& uri);

 private:
  std::shared_ptr<IChatTransportReader> mReader;  //!< The reader who will be notified when data is received.
  std::shared_ptr<ISocket> mSocket;               //!< The raw socket for sending and receiving chat messages on.
  std::shared_ptr<IWebSocket> mWebSocket;         //!< The websocket for sending and receiving chat messages on.
  std::vector<char> mBuffer;                      //!< A scratch buffer for reading data.
};
