/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"
#include "twitchsdk/core/user/user.h"

namespace ttv {
class User;

namespace chat {
class ChatUserBadges;
}
}  // namespace ttv

/**
 * Stores the IRC v3 message tag for user badges per channel.
 */
class ttv::chat::ChatUserBadges : public UserComponent {
 public:
  ChatUserBadges(const std::shared_ptr<User>& user);

  virtual std::string GetLoggerName() const override;
  static std::string GetComponentName() { return "ttv::chat::ChatUserBadges"; }

  std::string GetBadgesMessageTag(ChannelId channelId);
  void SetBadgesMessageTag(ChannelId channelId, const std::string& badgesMessageTag);

 private:
  std::unordered_map<ChannelId, std::string> mBadges;  //!< The mapping of channel ID to the badges message tag.
};
