/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#ifndef TTVSDK_CHATWRITER_H
#define TTVSDK_CHATWRITER_H

#include "twitchsdk/chat/ichattransport.h"
#include "twitchsdk/chat/internal/chatnetworkevent.h"

namespace ttv {
namespace chat {
class ChatWriter;
}
}  // namespace ttv

/**
 * Handles receiving a chat event and writing it to the transport.
 */
class ttv::chat::ChatWriter : public IChatWriteNetworkEvent {
 public:
  ChatWriter();
  ~ChatWriter();

  void SetTransport(std::shared_ptr<IChatTransport> pTransport);

  // IWriteNetworkEvent
  void WriteEvent(const ChatNetworkEvent& evt);

 protected:
  void WriteRaw(const std::string& message);

  std::shared_ptr<IChatTransport> mTransport;
  char mParseBuffer[IChatTransport::kMaxBufferSize];  //!< A scratch buffer for parsing lines.
};

#endif  // TTVSDK_CHATWRITER_H
