/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/json/jsonserialization.h"

#include <string>

namespace ttv {
namespace chat {
namespace graphql {
namespace json {
struct FetchChannelCheermotesCheermoteChatTheme;
struct FetchChannelCheermotesCheermoteImage;
struct FetchChannelCheermotesCheermoteTier;
struct FetchChannelCheermotesCheermoteType;
struct FetchChannelCheermotesCheermote;
struct FetchChannelCheermotesPayloadType;
struct FetchChannelCheermotesInputParams;
}  // namespace json

struct FetchChannelCheermotesQueryInfo {
  struct PayloadType {
    std::vector<BitsConfiguration::Cheermote> cheermotes;
  };

  struct InputParams {
    std::string authToken;
    std::string channelId;
  };

  static constexpr const char* kTaskName = "GraphQLTask: fetchChannelCheermotes";
  static constexpr auto kQuery = R"(
                query FetchChannelCheermotes($channelId: ID!)
                {
                    user(id: $channelId)
                    {
                        cheer
                        {
                            emotes(includeSponsored: true)
                            {
                                prefix
                                type
                                tiers
                                {
                                    tierID
                                    bits
                                    color
                                    canCheer
                                    canShowInBitsCard
                                    images
                                    {
                                        dpiScale
                                        isAnimated
                                        theme
                                        url
                                    }
                                }
                                campaign
                                {
                                    id
                                    bitsTotal
                                    bitsUsed
                                    minimumBitsAmount
                                    brandImageURL
                                    brandName
                                    thresholds
                                    {
                                        id
                                        matchedPercent
                                        minimumBits
                                    }
                                    bitsPercentageRemaining
                                    self
                                    {
                                        id
                                        bitsUsed
                                        canBeSponsored
                                    }
                                }
                            }
                        }
                    }
                })";
};
}  // namespace graphql
}  // namespace chat
}  // namespace ttv

struct ttv::chat::graphql::json::FetchChannelCheermotesCheermoteChatTheme {
  static auto EnumMap() {
    using namespace ttv::json;

    return std::make_tuple(make_enum_mapping("DARK", ttv::chat::BitsConfiguration::CheermoteImage::Theme::Dark),
      make_enum_mapping("LIGHT", ttv::chat::BitsConfiguration::CheermoteImage::Theme::Light));
  }

  static auto GetFallbackValue() { return ttv::chat::BitsConfiguration::CheermoteImage::Theme::Unknown; }
};

struct ttv::chat::graphql::json::FetchChannelCheermotesCheermoteImage {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& cheermoteImage) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>("dpiScale", cheermoteImage.dpiScale),
      make_field<RequiredField>("isAnimated", cheermoteImage.isAnimated),
      make_field<RequiredField>("theme", cheermoteImage.theme), make_field<RequiredField>("url", cheermoteImage.url));
  }
};

struct ttv::chat::graphql::json::FetchChannelCheermotesCheermoteTier {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& cheermoteTier) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>("tierID", cheermoteTier.tierID),
      make_field<RequiredField>("bits", cheermoteTier.bits),
      make_field<ColorSchema, RequiredField>("color", cheermoteTier.color),
      make_field<RequiredField>("canCheer", cheermoteTier.canCheer),
      make_field<RequiredField>("canShowInBitsCard", cheermoteTier.canShowInBitsCard),
      make_field<RequiredField>("images", cheermoteTier.images));
  }
};

struct ttv::chat::graphql::json::FetchChannelCheermotesCheermoteType {
  static auto EnumMap() {
    using namespace ttv::json;

    return std::make_tuple(make_enum_mapping("CUSTOM", ttv::chat::BitsConfiguration::Cheermote::Type::Custom),
      make_enum_mapping("SPONSORED", ttv::chat::BitsConfiguration::Cheermote::Type::Sponsored),
      make_enum_mapping("FIRST_PARTY", ttv::chat::BitsConfiguration::Cheermote::Type::FirstParty),
      make_enum_mapping("THIRD_PARTY", ttv::chat::BitsConfiguration::Cheermote::Type::ThirdParty),
      make_enum_mapping("DISPLAY_ONLY", ttv::chat::BitsConfiguration::Cheermote::Type::DisplayOnly));
  }

  static auto GetFallbackValue() { return ttv::chat::BitsConfiguration::Cheermote::Type::Unknown; }
};

struct ttv::chat::graphql::json::FetchChannelCheermotesCheermote {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& cheermote) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>("prefix", cheermote.prefix),
      make_field<RequiredField>("type", cheermote.type), make_field<RequiredField>("tiers", cheermote.tiers));
  }
};

struct ttv::chat::graphql::json::FetchChannelCheermotesPayloadType {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& payloadType) {
    using namespace ttv::json;

    return std::make_tuple(make_field<OptionalField>(MakeKeyPath("user", "cheer", "emotes"), payloadType.cheermotes));
  }
};

struct ttv::chat::graphql::json::FetchChannelCheermotesInputParams {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& inputParams) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>("channelId", inputParams.channelId));
  }
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::BitsConfiguration::CheermoteImage::Theme> {
  using Type = EnumSchema<ttv::chat::graphql::json::FetchChannelCheermotesCheermoteChatTheme>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::BitsConfiguration::CheermoteImage> {
  using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelCheermotesCheermoteImage>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::BitsConfiguration::CheermoteTier> {
  using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelCheermotesCheermoteTier>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::BitsConfiguration::Cheermote::Type> {
  using Type = EnumSchema<ttv::chat::graphql::json::FetchChannelCheermotesCheermoteType>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::BitsConfiguration::Cheermote> {
  using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelCheermotesCheermote>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelCheermotesQueryInfo::PayloadType> {
  using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelCheermotesPayloadType>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelCheermotesQueryInfo::InputParams> {
  using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelCheermotesInputParams>;
};
