/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/variant.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace chat
    {
        namespace graphql
        {
            namespace json
            {
                struct FetchChannelBadgesBadge;
                struct FetchChannelBadgesPayloadType;
                struct FetchChannelBadgesInputParams;
                struct FetchChannelBadgesBadgeClickAction;
            }

            struct FetchChannelBadgesQueryInfo
            {
                enum class BadgeClickAction
                {
                    SUBSCRIBE,
                    GET_TURBO,
                    GET_BITS,
                    VISIT_URL,
                };

                struct Badge
                {
                    ttv::Optional<std::string> clickURL;
                    std::string description;
                    std::string imageUrlNormal;
                    std::string imageUrlDouble;
                    std::string imageUrlQuadruple;
                    ttv::Optional<BadgeClickAction> onClickAction;
                    std::string setID;
                    std::string title;
                    std::string version;
                };

                struct PayloadType
                {
                    ttv::Optional<std::vector<ttv::Optional<Badge>>> broadcastBadges;
                };

                struct InputParams
                {
                    std::string authToken;
                    std::string channelId;
                };

                static constexpr const char* kTaskName = "GraphQLTask: FetchChannelBadges";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query FetchChannelBadges($channelId:ID!)
                    {
                        user(id:$channelId)
                        {
                            broadcastBadges
                            {
                                clickURL
                                description
                                imageUrlNormal:imageURL(size: NORMAL)
                                imageUrlDouble:imageURL(size: DOUBLE)
                                imageUrlQuadruple:imageURL(size: QUADRUPLE)
                                onClickAction
                                setID
                                title
                                version
                            }
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::chat::graphql::json::FetchChannelBadgesBadge
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& badge)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("clickURL", badge.clickURL),
            make_field<RequiredField>("description", badge.description),
            make_field<RequiredField>("imageUrlNormal", badge.imageUrlNormal),
            make_field<RequiredField>("imageUrlDouble", badge.imageUrlDouble),
            make_field<RequiredField>("imageUrlQuadruple", badge.imageUrlQuadruple),
            make_field<OptionalField>("onClickAction", badge.onClickAction),
            make_field<RequiredField>("setID", badge.setID),
            make_field<RequiredField>("title", badge.title),
            make_field<RequiredField>("version", badge.version)
        );
    }
};


struct ttv::chat::graphql::json::FetchChannelBadgesPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>(MakeKeyPath("user", "broadcastBadges"), payloadType.broadcastBadges)
        );
    }
};


struct ttv::chat::graphql::json::FetchChannelBadgesInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("channelId", inputParams.channelId)
        );
    }
};


struct ttv::chat::graphql::json::FetchChannelBadgesBadgeClickAction
{
    static auto EnumMap()
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_enum_mapping_case_insensitive("SUBSCRIBE", FetchChannelBadgesQueryInfo::BadgeClickAction::SUBSCRIBE),
            make_enum_mapping_case_insensitive("GET_TURBO", FetchChannelBadgesQueryInfo::BadgeClickAction::GET_TURBO),
            make_enum_mapping_case_insensitive("GET_BITS", FetchChannelBadgesQueryInfo::BadgeClickAction::GET_BITS),
            make_enum_mapping_case_insensitive("VISIT_URL", FetchChannelBadgesQueryInfo::BadgeClickAction::VISIT_URL)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelBadgesQueryInfo::Badge>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelBadgesBadge>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelBadgesQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelBadgesPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelBadgesQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelBadgesInputParams>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelBadgesQueryInfo::BadgeClickAction>
{
    using Type = EnumSchema<ttv::chat::graphql::json::FetchChannelBadgesBadgeClickAction>;
};
