/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from modules/chat/chat_common/graphql/fetchchannelvips.graphql

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace chat
    {
        namespace graphql
        {
            namespace json
            {
                struct FetchChannelVIPsUser;
                struct FetchChannelVIPsVIPEdge;
                struct FetchChannelVIPsVIPConnection;
                struct FetchChannelVIPsPayloadType;
                struct FetchChannelVIPsInputParams;
            }

            struct FetchChannelVIPsQueryInfo
            {
                struct User
                {
                    ttv::Optional<std::string> login;
                };

                struct VIPEdge
                {
                    ttv::Optional<User> node;
                };

                struct VIPConnection
                {
                    std::vector<VIPEdge> edges;
                };

                struct PayloadType
                {
                    ttv::Optional<VIPConnection> vips;
                };

                struct InputParams
                {
                    std::string channelId;
                };

                static constexpr const char* kTaskName = "GraphQLTask: FetchChannelVIPs";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query FetchChannelVIPs($channelId: ID!)
                    {
                        user(id: $channelId)
                        {
                            vips(first: 100)
                            {
                                edges
                                {
                                    node
                                    {
                                        login
                                    }
                                }
                            }
                        }
                    }
                )";
            };

        }
    }
}


struct ttv::chat::graphql::json::FetchChannelVIPsUser
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& user)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("login", user.login)
        );
    }
};


struct ttv::chat::graphql::json::FetchChannelVIPsVIPEdge
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& vIPEdge)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("node", vIPEdge.node)
        );
    }
};


struct ttv::chat::graphql::json::FetchChannelVIPsVIPConnection
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& vIPConnection)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("edges", vIPConnection.edges)
        );
    }
};


struct ttv::chat::graphql::json::FetchChannelVIPsPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>(MakeKeyPath("user", "vips"), payloadType.vips)
        );
    }
};


struct ttv::chat::graphql::json::FetchChannelVIPsInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("channelId", inputParams.channelId)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelVIPsQueryInfo::User>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelVIPsUser>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelVIPsQueryInfo::VIPEdge>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelVIPsVIPEdge>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelVIPsQueryInfo::VIPConnection>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelVIPsVIPConnection>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelVIPsQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelVIPsPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChannelVIPsQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChannelVIPsInputParams>;
};



