/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace chat
    {
        namespace graphql
        {
            namespace json
            {
                struct FetchChatSettingsChatSettings;
                struct FetchChatSettingsPayloadType;
                struct FetchChatSettingsInputParams;
            }

            struct FetchChatSettingsQueryInfo
            {
                struct ChatSettings
                {
                    int32_t autoModLevel;
                    bool blockLinks;
                    int32_t chatDelayMs;
                    ttv::Optional<int32_t> followersOnlyDurationMinutes;
                    bool isBroadcasterLanguageModeEnabled;
                    bool isEmoteOnlyModeEnabled;
                    bool isFastSubsModeEnabled;
                    bool isOptedOutOfGlobalBannedWordsList;
                    bool isSubscribersOnlyModeEnabled;
                    bool isUniqueChatModeEnabled;
                    bool requireVerifiedAccount;
                    std::vector<std::string> rules;
                    ttv::Optional<int32_t> slowModeDurationSeconds;
                };

                struct PayloadType
                {
                    ttv::Optional<ChatSettings> chatSettings;
                };

                struct InputParams
                {
                    std::string authToken;
                    std::string channelId;
                };

                static constexpr const char* kTaskName = "GraphQLTask: FetchChatSettings";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query FetchChatSettings($channelId: ID!) {
                        user(id: $channelId)
                        {
                            chatSettings
                            {
                                autoModLevel
                                blockLinks
                                chatDelayMs
                                followersOnlyDurationMinutes
                                isBroadcasterLanguageModeEnabled
                                isEmoteOnlyModeEnabled
                                isFastSubsModeEnabled
                                isOptedOutOfGlobalBannedWordsList
                                isSubscribersOnlyModeEnabled
                                isUniqueChatModeEnabled
                                requireVerifiedAccount
                                rules
                                slowModeDurationSeconds
                            }
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::chat::graphql::json::FetchChatSettingsChatSettings
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& chatSettings)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("autoModLevel", chatSettings.autoModLevel),
            make_field<RequiredField>("blockLinks", chatSettings.blockLinks),
            make_field<RequiredField>("chatDelayMs", chatSettings.chatDelayMs),
            make_field<OptionalField>("followersOnlyDurationMinutes", chatSettings.followersOnlyDurationMinutes),
            make_field<RequiredField>("isBroadcasterLanguageModeEnabled", chatSettings.isBroadcasterLanguageModeEnabled),
            make_field<RequiredField>("isEmoteOnlyModeEnabled", chatSettings.isEmoteOnlyModeEnabled),
            make_field<RequiredField>("isFastSubsModeEnabled", chatSettings.isFastSubsModeEnabled),
            make_field<RequiredField>("isOptedOutOfGlobalBannedWordsList", chatSettings.isOptedOutOfGlobalBannedWordsList),
            make_field<RequiredField>("isSubscribersOnlyModeEnabled", chatSettings.isSubscribersOnlyModeEnabled),
            make_field<RequiredField>("isUniqueChatModeEnabled", chatSettings.isUniqueChatModeEnabled),
            make_field<RequiredField>("requireVerifiedAccount", chatSettings.requireVerifiedAccount),
            make_field<RequiredField>("rules", chatSettings.rules),
            make_field<OptionalField>("slowModeDurationSeconds", chatSettings.slowModeDurationSeconds)
        );
    }
};


struct ttv::chat::graphql::json::FetchChatSettingsPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>(MakeKeyPath("user", "chatSettings"), payloadType.chatSettings)
        );
    }
};


struct ttv::chat::graphql::json::FetchChatSettingsInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("channelId", inputParams.channelId)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChatSettingsQueryInfo::ChatSettings>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChatSettingsChatSettings>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChatSettingsQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChatSettingsPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchChatSettingsQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchChatSettingsInputParams>;
};


