/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/variant.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace chat
    {
        namespace graphql
        {
            namespace json
            {
                struct FetchGlobalBadgesBadge;
                struct FetchGlobalBadgesPayloadType;
                struct FetchGlobalBadgesInputParams;
                struct FetchGlobalBadgesBadgeClickAction;
            }

            struct FetchGlobalBadgesQueryInfo
            {
                enum class BadgeClickAction
                {
                    SUBSCRIBE,
                    GET_TURBO,
                    GET_BITS,
                    VISIT_URL,
                };

                struct Badge
                {
                    ttv::Optional<std::string> clickURL;
                    std::string description;
                    std::string imageUrlNormal;
                    std::string imageUrlDouble;
                    std::string imageUrlQuadruple;
                    ttv::Optional<BadgeClickAction> onClickAction;
                    std::string setID;
                    std::string title;
                    std::string version;
                };

                struct PayloadType
                {
                    ttv::Optional<std::vector<ttv::Optional<Badge>>> badges;
                };

                struct InputParams
                {
                    std::string authToken;
                };

                static constexpr const char* kTaskName = "GraphQLTask: FetchGlobalBadges";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query FetchGlobalBadges
                    {
                        badges
                        {
                            clickURL
                            description
                            imageUrlNormal:imageURL(size: NORMAL)
                            imageUrlDouble:imageURL(size: DOUBLE)
                            imageUrlQuadruple:imageURL(size: QUADRUPLE)
                            onClickAction
                            setID
                            title
                            version
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::chat::graphql::json::FetchGlobalBadgesBadge
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& badge)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("clickURL", badge.clickURL),
            make_field<RequiredField>("description", badge.description),
            make_field<RequiredField>("imageUrlNormal", badge.imageUrlNormal),
            make_field<RequiredField>("imageUrlDouble", badge.imageUrlDouble),
            make_field<RequiredField>("imageUrlQuadruple", badge.imageUrlQuadruple),
            make_field<OptionalField>("onClickAction", badge.onClickAction),
            make_field<RequiredField>("setID", badge.setID),
            make_field<RequiredField>("title", badge.title),
            make_field<RequiredField>("version", badge.version)
        );
    }
};


struct ttv::chat::graphql::json::FetchGlobalBadgesPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("badges", payloadType.badges)
        );
    }
};


struct ttv::chat::graphql::json::FetchGlobalBadgesInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
        );
        (void)inputParams;
    }
};


struct ttv::chat::graphql::json::FetchGlobalBadgesBadgeClickAction
{
    static auto EnumMap()
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_enum_mapping_case_insensitive("SUBSCRIBE", FetchGlobalBadgesQueryInfo::BadgeClickAction::SUBSCRIBE),
            make_enum_mapping_case_insensitive("GET_TURBO", FetchGlobalBadgesQueryInfo::BadgeClickAction::GET_TURBO),
            make_enum_mapping_case_insensitive("GET_BITS", FetchGlobalBadgesQueryInfo::BadgeClickAction::GET_BITS),
            make_enum_mapping_case_insensitive("VISIT_URL", FetchGlobalBadgesQueryInfo::BadgeClickAction::VISIT_URL)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchGlobalBadgesQueryInfo::Badge>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchGlobalBadgesBadge>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchGlobalBadgesQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchGlobalBadgesPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchGlobalBadgesQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::FetchGlobalBadgesInputParams>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::FetchGlobalBadgesQueryInfo::BadgeClickAction>
{
    using Type = EnumSchema<ttv::chat::graphql::json::FetchGlobalBadgesBadgeClickAction>;
};
