/********************************************************************************************
* Twitch Platforms SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2018 Twitch Interactive, Inc.
*********************************************************************************************/

/* DO NOT EDIT THIS FILE - it is machine generated */

namespace ttv
{
    namespace chat
    {
        namespace graphql
        {
            constexpr const char* GetFetchRoomMessagesBeforeCursorQuery()
            {
                return R"(
                    query FetchRoomMessagesBeforeCursor($roomId: ID!, $limit: Int, $cursor: Cursor, $channelId: ID)
                    {
                        room(id: $roomId)
                        {
                            messages(before: $cursor, last: $limit)
                            {
                                ... RoomMessagesFragment
                            }
                        }
                    }

                    fragment RoomMessagesFragment on RoomMessageConnection
                    {
                        edges
                        {
                            cursor
                            node
                            {
                                ... on RoomMessage
                                {
                                    ... RoomMessageChannelIdFragment
                                }
                            }
                        }
                        pageInfo
                        {
                            hasNextPage
                            hasPreviousPage
                        }
                    }

                    fragment RoomMessageChannelIdFragment on RoomMessage
                    {
                        id
                        room
                        {
                            id
                        }
                        sentAt
                        deletedAt
                        content
                        {
                            fragments
                            {
                                text
                                content
                                {
                                    ... on Emote
                                    {
                                        id
                                    }
                                    ... on User {
                                        displayName
                                    }
                                    __typename
                                }
                            }
                        }
                        sender
                        {
                            id
                            displayName
                            login
                            chatColor
                            displayBadges(channelID: $channelId)
                            {
                                setID
                                version
                            }
                            roles
                            {
                                isGlobalMod
                                isSiteAdmin
                                isStaff
                            }
                        }
                    }
                )";
            }
        }
    }
}
