/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace chat
    {
        namespace graphql
        {
            namespace json
            {
                struct GetChannelPropertiesChatSettings;
                struct GetChannelPropertiesPayloadType;
                struct GetChannelPropertiesInputParams;
            }

            struct GetChannelPropertiesQueryInfo
            {
                struct ChatSettings
                {
                    int32_t chatDelayMs;
                    std::vector<std::string> rules;
                    bool blockLinks;
                };

                struct PayloadType
                {
                    ttv::Optional<ChatSettings> chatSettings;
                };

                struct InputParams
                {
                    std::string authToken;
                    std::string id;
                };

                static constexpr const char* kTaskName = "GraphQLTask: GetChannelProperties";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query GetChannelProperties($id:ID!) {
                        user(id:$id) {
                            chatSettings {
                                chatDelayMs
                                rules
                                blockLinks
                            }
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::chat::graphql::json::GetChannelPropertiesChatSettings
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& chatSettings)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("chatDelayMs", chatSettings.chatDelayMs),
            make_field<RequiredField>("rules", chatSettings.rules),
            make_field<RequiredField>("blockLinks", chatSettings.blockLinks)
        );
    }
};


struct ttv::chat::graphql::json::GetChannelPropertiesPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>(MakeKeyPath("user", "chatSettings"), payloadType.chatSettings)
        );
    }
};


struct ttv::chat::graphql::json::GetChannelPropertiesInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("id", inputParams.id)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::GetChannelPropertiesQueryInfo::ChatSettings>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::GetChannelPropertiesChatSettings>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::GetChannelPropertiesQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::GetChannelPropertiesPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::GetChannelPropertiesQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::GetChannelPropertiesInputParams>;
};
