/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace chat
    {
        namespace graphql
        {
            namespace json
            {
                struct GetChatBlockListUser;
                struct GetChatBlockListPayloadType;
                struct GetChatBlockListInputParams;
            }

            struct GetChatBlockListQueryInfo
            {
                struct User
                {
                    ttv::Optional<std::string> login;
                    ttv::Optional<std::string> displayName;
                    ttv::Optional<std::string> description;
                    ttv::Optional<std::string> profileImageURL;
                    std::string id;
                    ttv::Optional<ttv::Timestamp> createdAt;
                };

                struct PayloadType
                {
                    std::vector<ttv::Optional<User>> blockedUsers;
                };

                struct InputParams
                {
                    std::string authToken;
                    ttv::Optional<std::string> userId;
                };

                static constexpr const char* kTaskName = "GraphQLTask: GetChatBlockList";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query GetChatBlockList($userId:ID) {
                        user(id:$userId) {
                            blockedUsers {
                                login
                                displayName
                                description
                                profileImageURL(width:300)
                                id
                                createdAt
                            }
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::chat::graphql::json::GetChatBlockListUser
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& user)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("login", user.login),
            make_field<OptionalField>("displayName", user.displayName),
            make_field<OptionalField>("description", user.description),
            make_field<OptionalField>("profileImageURL", user.profileImageURL),
            make_field<RequiredField>("id", user.id),
            make_field<OptionalField>("createdAt", user.createdAt)
        );
    }
};


struct ttv::chat::graphql::json::GetChatBlockListPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>(MakeKeyPath("user", "blockedUsers"), payloadType.blockedUsers)
        );
    }
};


struct ttv::chat::graphql::json::GetChatBlockListInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("userId", inputParams.userId)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::GetChatBlockListQueryInfo::User>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::GetChatBlockListUser>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::GetChatBlockListQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::GetChatBlockListPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::GetChatBlockListQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::chat::graphql::json::GetChatBlockListInputParams>;
};
