/****************************************************************************
 * Twitch Cross-Platform Client Application
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2016-2019 Twitch Interactive, Inc.
 ***************************************************************************/
 
// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
  namespace core
  {
    namespace graphql
    {
      namespace json
      {
        struct CreateVideoCommentMutationUser;
        struct CreateVideoCommentMutationVideo;
        struct CreateVideoCommentMutationUser1;
        struct CreateVideoCommentMutationUser2;
        struct CreateVideoCommentMutationEmbeddedEmote;
        struct CreateVideoCommentMutationVideoCommentMessageFragment;
        struct CreateVideoCommentMutationBadge;
        struct CreateVideoCommentMutationVideoCommentMessage;
        struct CreateVideoCommentMutationVideoComment;
        struct CreateVideoCommentMutationPayloadType;
        struct CreateVideoCommentMutationInputParams;
        struct CreateVideoCommentMutationVideoCommentSource;
        struct CreateVideoCommentMutationVideoCommentState;
      }

      struct CreateVideoCommentMutationQueryInfo
      {
        enum class VideoCommentSource
        {
          CHAT,
          COMMENT,
          UNKNOWN,
        };

        enum class VideoCommentState
        {
          PUBLISHED,
          UNPUBLISHED,
          PENDING_REVIEW,
          PENDING_REVIEW_SPAM,
          DELETED,
        };

        struct User
        {
          std::string id;
        };

        struct Video
        {
          std::string id;
          ttv::Optional<User> owner;
        };

        struct User1
        {
          ttv::Optional<std::string> login;
          ttv::Optional<std::string> displayName;
          std::string id;
        };

        struct User2
        {
          std::string id;
          ttv::Optional<std::string> login;
          ttv::Optional<std::string> displayName;
        };

        struct EmbeddedEmote
        {
          ttv::Optional<std::string> emoteID;
          ttv::Optional<int32_t> from;
          ttv::Optional<std::string> id;
          ttv::Optional<std::string> setID;
          ttv::Optional<int32_t> to;
        };

        struct VideoCommentMessageFragment
        {
          std::string text;
          ttv::Optional<User2> mention;
          ttv::Optional<EmbeddedEmote> emote;
        };

        struct Badge
        {
          std::string setID;
          std::string version;
        };

        struct VideoCommentMessage
        {
          ttv::Optional<std::vector<ttv::Optional<VideoCommentMessageFragment>>> fragments;
          ttv::Optional<std::vector<ttv::Optional<Badge>>> userBadges;
          ttv::Optional<std::string> userColor;
        };

        struct VideoComment
        {
          std::string id;
          ttv::Optional<Video> video;
          int32_t contentOffsetSeconds;
          ttv::Timestamp updatedAt;
          ttv::Timestamp createdAt;
          VideoCommentSource source;
          VideoCommentState state;
          ttv::Optional<User1> commenter;
          ttv::Optional<VideoCommentMessage> message;
        };

        struct PayloadType
        {
          VideoComment comment;
        };

        struct InputParams
        {
          std::string authToken;
          ttv::Optional<std::string> commentID;
          std::string message;
          std::string videoID;
          int32_t contentOffsetSeconds;
        };

        static constexpr const char* kTaskName = "GraphQLTask: CreateVideoCommentMutation";
        static constexpr auto kQuery = R"(
          # gen_full
          mutation CreateVideoCommentMutation($commentID: ID,
          $contentOffsetSeconds: Int!,
          $message: String!,
          $videoID: ID!) {
            createVideoComment(input: {
              commentID: $commentID,
              contentOffsetSeconds: $contentOffsetSeconds,
              message: $message,
              videoID: $videoID }) {
                comment {
                  id
                  video {
                    id
                    owner {
                      id
                    }
                  }
                  contentOffsetSeconds
                  updatedAt
                  createdAt
                  source
                  state
                  commenter {
                    login
                    displayName
                    id
                  }
                  message {
                    fragments {
                      text
                      mention {
                        id
                        login
                        displayName
                      }
                      emote {
                        emoteID
                        from
                        id
                        setID
                        to
                      }
                    }
                    userBadges {
                      setID
                      version
                    }
                    userColor
                  }
                }
              }
            }
          )";
      };
    }
  }
}


struct ttv::core::graphql::json::CreateVideoCommentMutationUser
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& user)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<RequiredField>("id", user.id)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationVideo
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& video)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<RequiredField>("id", video.id),
      make_field<OptionalField>("owner", video.owner)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationUser1
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& user1)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<OptionalField>("login", user1.login),
      make_field<OptionalField>("displayName", user1.displayName),
      make_field<RequiredField>("id", user1.id)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationUser2
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& user2)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<RequiredField>("id", user2.id),
      make_field<OptionalField>("login", user2.login),
      make_field<OptionalField>("displayName", user2.displayName)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationEmbeddedEmote
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& embeddedEmote)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<OptionalField>("emoteID", embeddedEmote.emoteID),
      make_field<OptionalField>("from", embeddedEmote.from),
      make_field<OptionalField>("id", embeddedEmote.id),
      make_field<OptionalField>("setID", embeddedEmote.setID),
      make_field<OptionalField>("to", embeddedEmote.to)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationVideoCommentMessageFragment
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& videoCommentMessageFragment)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<RequiredField>("text", videoCommentMessageFragment.text),
      make_field<OptionalField>("mention", videoCommentMessageFragment.mention),
      make_field<OptionalField>("emote", videoCommentMessageFragment.emote)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationBadge
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& badge)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<RequiredField>("setID", badge.setID),
      make_field<RequiredField>("version", badge.version)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationVideoCommentMessage
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& videoCommentMessage)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<OptionalField>("fragments", videoCommentMessage.fragments),
      make_field<OptionalField>("userBadges", videoCommentMessage.userBadges),
      make_field<OptionalField>("userColor", videoCommentMessage.userColor)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationVideoComment
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& videoComment)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<RequiredField>("id", videoComment.id),
      make_field<OptionalField>("video", videoComment.video),
      make_field<RequiredField>("contentOffsetSeconds", videoComment.contentOffsetSeconds),
      make_field<RequiredField>("updatedAt", videoComment.updatedAt),
      make_field<RequiredField>("createdAt", videoComment.createdAt),
      make_field<RequiredField>("source", videoComment.source),
      make_field<RequiredField>("state", videoComment.state),
      make_field<OptionalField>("commenter", videoComment.commenter),
      make_field<OptionalField>("message", videoComment.message)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationPayloadType
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& payloadType)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<RequiredField>(MakeKeyPath("createVideoComment", "comment"), payloadType.comment)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationInputParams
{
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& inputParams)
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_field<OptionalField>("commentID", inputParams.commentID),
      make_field<RequiredField>("message", inputParams.message),
      make_field<RequiredField>("videoID", inputParams.videoID),
      make_field<RequiredField>("contentOffsetSeconds", inputParams.contentOffsetSeconds)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationVideoCommentSource
{
  static auto EnumMap()
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_enum_mapping_case_insensitive("CHAT", CreateVideoCommentMutationQueryInfo::VideoCommentSource::CHAT),
      make_enum_mapping_case_insensitive("COMMENT", CreateVideoCommentMutationQueryInfo::VideoCommentSource::COMMENT),
      make_enum_mapping_case_insensitive("UNKNOWN", CreateVideoCommentMutationQueryInfo::VideoCommentSource::UNKNOWN)
    );
  }
};


struct ttv::core::graphql::json::CreateVideoCommentMutationVideoCommentState
{
  static auto EnumMap()
  {
    using namespace ttv::json;

    return std::make_tuple
    (
      make_enum_mapping_case_insensitive("PUBLISHED", CreateVideoCommentMutationQueryInfo::VideoCommentState::PUBLISHED),
      make_enum_mapping_case_insensitive("UNPUBLISHED", CreateVideoCommentMutationQueryInfo::VideoCommentState::UNPUBLISHED),
      make_enum_mapping_case_insensitive("PENDING_REVIEW", CreateVideoCommentMutationQueryInfo::VideoCommentState::PENDING_REVIEW),
      make_enum_mapping_case_insensitive("PENDING_REVIEW_SPAM", CreateVideoCommentMutationQueryInfo::VideoCommentState::PENDING_REVIEW_SPAM),
      make_enum_mapping_case_insensitive("DELETED", CreateVideoCommentMutationQueryInfo::VideoCommentState::DELETED)
    );
  }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::User>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationUser>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::Video>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationVideo>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::User1>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationUser1>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::User2>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationUser2>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::EmbeddedEmote>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationEmbeddedEmote>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::VideoCommentMessageFragment>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationVideoCommentMessageFragment>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::Badge>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationBadge>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::VideoCommentMessage>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationVideoCommentMessage>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::VideoComment>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationVideoComment>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::PayloadType>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::InputParams>
{
  using Type = ObjectSchema<ttv::core::graphql::json::CreateVideoCommentMutationInputParams>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::VideoCommentSource>
{
  using Type = EnumSchema<ttv::core::graphql::json::CreateVideoCommentMutationVideoCommentSource>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::CreateVideoCommentMutationQueryInfo::VideoCommentState>
{
  using Type = EnumSchema<ttv::core::graphql::json::CreateVideoCommentMutationVideoCommentState>;
};

