/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/variant.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace core
    {
        namespace graphql
        {
            namespace json
            {
                struct VideoCommentsUser;
                struct VideoCommentsVideo;
                struct VideoCommentsUser1;
                struct VideoCommentsUser2;
                struct VideoCommentsEmbeddedEmote;
                struct VideoCommentsVideoCommentMessageFragment;
                struct VideoCommentsBadge;
                struct VideoCommentsVideoCommentMessage;
                struct VideoCommentsVideoComment;
                struct VideoCommentsVideoCommentEdge;
                struct VideoCommentsPageInfo;
                struct VideoCommentsVideoCommentConnection;
                struct VideoCommentsPayloadType;
                struct VideoCommentsInputParams;
                struct VideoCommentsVideoCommentSource;
                struct VideoCommentsVideoCommentState;
            }

            struct VideoCommentsQueryInfo
            {
                enum class VideoCommentSource
                {
                    CHAT,
                    COMMENT,
                    UNKNOWN,
                };

                enum class VideoCommentState
                {
                    PUBLISHED,
                    UNPUBLISHED,
                    PENDING_REVIEW,
                    PENDING_REVIEW_SPAM,
                    DELETED,
                };

                struct User
                {
                    std::string id;
                };

                struct Video
                {
                    std::string id;
                    ttv::Optional<User> owner;
                };

                struct User1
                {
                    ttv::Optional<std::string> login;
                    ttv::Optional<std::string> displayName;
                    std::string id;
                };

                struct User2
                {
                    std::string id;
                    ttv::Optional<std::string> login;
                    ttv::Optional<std::string> displayName;
                };

                struct EmbeddedEmote
                {
                    ttv::Optional<std::string> emoteID;
                    ttv::Optional<int32_t> from;
                    ttv::Optional<std::string> id;
                    ttv::Optional<std::string> setID;
                    ttv::Optional<int32_t> to;
                };

                struct VideoCommentMessageFragment
                {
                    std::string text;
                    ttv::Optional<User2> mention;
                    ttv::Optional<EmbeddedEmote> emote;
                };

                struct Badge
                {
                    std::string setID;
                    std::string version;
                };

                struct VideoCommentMessage
                {
                    ttv::Optional<std::vector<ttv::Optional<VideoCommentMessageFragment>>> fragments;
                    ttv::Optional<std::vector<ttv::Optional<Badge>>> userBadges;
                    ttv::Optional<std::string> userColor;
                };

                struct VideoComment
                {
                    std::string id;
                    ttv::Optional<Video> video;
                    int32_t contentOffsetSeconds;
                    ttv::Timestamp updatedAt;
                    ttv::Timestamp createdAt;
                    VideoCommentSource source;
                    VideoCommentState state;
                    ttv::Optional<User1> commenter;
                    ttv::Optional<VideoCommentMessage> message;
                };

                struct VideoCommentEdge
                {
                    ttv::Optional<std::string> cursor;
                    ttv::Optional<VideoComment> node;
                };

                struct PageInfo
                {
                    bool hasNextPage;
                };

                struct VideoCommentConnection
                {
                    ttv::Optional<std::vector<ttv::Optional<VideoCommentEdge>>> edges;
                    PageInfo pageInfo;
                };

                struct PayloadType
                {
                    ttv::Optional<VideoCommentConnection> comments;
                };

                struct InputParams
                {
                    std::string authToken;
                    ttv::Optional<std::string> cursor;
                    ttv::Optional<int32_t> contentOffsetSeconds;
                    int32_t limit;
                    std::string videoID;
                };

                static constexpr const char* kTaskName = "GraphQLTask: VideoComments";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query VideoComments($videoID: ID!, $limit: Int!, $cursor: Cursor, $contentOffsetSeconds: Int)
                    {
                        video (id: $videoID)
                        {
                            comments (first: $limit, after: $cursor, contentOffsetSeconds: $contentOffsetSeconds)
                            {
                                edges {
                                    cursor
                                    node {
                                        id
                                        video {
                                            id
                                            owner {
                                                id
                                            }
                                        }
                                        contentOffsetSeconds
                                        updatedAt
                                        createdAt
                                        source
                                        state
                                        commenter {
                                            login
                                            displayName
                                            id
                                        }
                                        message {
                                            fragments {
                                                text
                                                mention {
                                                    id
                                                    login
                                                    displayName
                                                }
                                                emote {
                                                    emoteID
                                                    from
                                                    id
                                                    setID
                                                    to
                                                }
                                            }
                                            userBadges {
                                                setID
                                                version
                                            }
                                            userColor
                                        }
                                    }
                                }
                                pageInfo {
                                    hasNextPage
                                }
                            }
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::core::graphql::json::VideoCommentsUser
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& user)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("id", user.id)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsVideo
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& video)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("id", video.id),
            make_field<OptionalField>("owner", video.owner)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsUser1
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& user1)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("login", user1.login),
            make_field<OptionalField>("displayName", user1.displayName),
            make_field<RequiredField>("id", user1.id)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsUser2
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& user2)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("id", user2.id),
            make_field<OptionalField>("login", user2.login),
            make_field<OptionalField>("displayName", user2.displayName)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsEmbeddedEmote
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& embeddedEmote)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("emoteID", embeddedEmote.emoteID),
            make_field<OptionalField>("from", embeddedEmote.from),
            make_field<OptionalField>("id", embeddedEmote.id),
            make_field<OptionalField>("setID", embeddedEmote.setID),
            make_field<OptionalField>("to", embeddedEmote.to)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsVideoCommentMessageFragment
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& videoCommentMessageFragment)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("text", videoCommentMessageFragment.text),
            make_field<OptionalField>("mention", videoCommentMessageFragment.mention),
            make_field<OptionalField>("emote", videoCommentMessageFragment.emote)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsBadge
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& badge)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("setID", badge.setID),
            make_field<RequiredField>("version", badge.version)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsVideoCommentMessage
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& videoCommentMessage)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("fragments", videoCommentMessage.fragments),
            make_field<OptionalField>("userBadges", videoCommentMessage.userBadges),
            make_field<OptionalField>("userColor", videoCommentMessage.userColor)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsVideoComment
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& videoComment)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("id", videoComment.id),
            make_field<OptionalField>("video", videoComment.video),
            make_field<RequiredField>("contentOffsetSeconds", videoComment.contentOffsetSeconds),
            make_field<RequiredField>("updatedAt", videoComment.updatedAt),
            make_field<RequiredField>("createdAt", videoComment.createdAt),
            make_field<RequiredField>("source", videoComment.source),
            make_field<RequiredField>("state", videoComment.state),
            make_field<OptionalField>("commenter", videoComment.commenter),
            make_field<OptionalField>("message", videoComment.message)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsVideoCommentEdge
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& videoCommentEdge)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("cursor", videoCommentEdge.cursor),
            make_field<OptionalField>("node", videoCommentEdge.node)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsPageInfo
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& pageInfo)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("hasNextPage", pageInfo.hasNextPage)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsVideoCommentConnection
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& videoCommentConnection)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("edges", videoCommentConnection.edges),
            make_field<RequiredField>("pageInfo", videoCommentConnection.pageInfo)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>(MakeKeyPath("video", "comments"), payloadType.comments)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("cursor", inputParams.cursor),
            make_field<OptionalField>("contentOffsetSeconds", inputParams.contentOffsetSeconds),
            make_field<RequiredField>("limit", inputParams.limit),
            make_field<RequiredField>("videoID", inputParams.videoID)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsVideoCommentSource
{
    static auto EnumMap()
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_enum_mapping_case_insensitive("CHAT", VideoCommentsQueryInfo::VideoCommentSource::CHAT),
            make_enum_mapping_case_insensitive("COMMENT", VideoCommentsQueryInfo::VideoCommentSource::COMMENT),
            make_enum_mapping_case_insensitive("UNKNOWN", VideoCommentsQueryInfo::VideoCommentSource::UNKNOWN)
        );
    }
};


struct ttv::core::graphql::json::VideoCommentsVideoCommentState
{
    static auto EnumMap()
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_enum_mapping_case_insensitive("PUBLISHED", VideoCommentsQueryInfo::VideoCommentState::PUBLISHED),
            make_enum_mapping_case_insensitive("UNPUBLISHED", VideoCommentsQueryInfo::VideoCommentState::UNPUBLISHED),
            make_enum_mapping_case_insensitive("PENDING_REVIEW", VideoCommentsQueryInfo::VideoCommentState::PENDING_REVIEW),
            make_enum_mapping_case_insensitive("PENDING_REVIEW_SPAM", VideoCommentsQueryInfo::VideoCommentState::PENDING_REVIEW_SPAM),
            make_enum_mapping_case_insensitive("DELETED", VideoCommentsQueryInfo::VideoCommentState::DELETED)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::User>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsUser>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::Video>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsVideo>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::User1>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsUser1>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::User2>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsUser2>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::EmbeddedEmote>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsEmbeddedEmote>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::VideoCommentMessageFragment>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsVideoCommentMessageFragment>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::Badge>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsBadge>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::VideoCommentMessage>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsVideoCommentMessage>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::VideoComment>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsVideoComment>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::VideoCommentEdge>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsVideoCommentEdge>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::PageInfo>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsPageInfo>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::VideoCommentConnection>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsVideoCommentConnection>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::core::graphql::json::VideoCommentsInputParams>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::VideoCommentSource>
{
    using Type = EnumSchema<ttv::core::graphql::json::VideoCommentsVideoCommentSource>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::VideoCommentsQueryInfo::VideoCommentState>
{
    using Type = EnumSchema<ttv::core::graphql::json::VideoCommentsVideoCommentState>;
};
