/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chaterrortypes.h"
#include "twitchsdk/core/json/jsonserialization.h"
#include "twitchsdk/core/optional.h"

namespace ttv {
namespace chat {
namespace graphql {
namespace json {
struct GrantVIPGrantVIPInput;
struct GrantVIPGrantVIPError;
struct GrantVIPPayloadType;
struct GrantVIPInputParams;
struct GrantVIPErrorCode;
}  // namespace json

struct GrantVIPQueryInfo {
  struct GrantVIPInput {
    std::string channelID;
    ttv::Optional<std::string> granteeID;
    ttv::Optional<std::string> granteeLogin;
  };

  struct GrantVIPError {
    GrantVIPErrorCode code;
  };

  struct PayloadType {
    ttv::Optional<GrantVIPError> error;
  };

  struct InputParams {
    GrantVIPInput input;
    std::string authToken;
  };

  static constexpr const char* kTaskName = "GraphQLTask: GrantVIP";
  static constexpr auto kQuery = R"(
                    # gen_full
                    mutation GrantVIP($input: GrantVIPInput!)
                    {
                        grantVIP(input: $input)
                        {
                            error
                            {
                                code
                            }
                        }
                    }
                )";
};
}  // namespace graphql
}  // namespace chat
}  // namespace ttv

struct ttv::chat::graphql::json::GrantVIPGrantVIPInput {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& grantVIPInput) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>("channelID", grantVIPInput.channelID),
      make_field<OptionalField>("granteeID", grantVIPInput.granteeID),
      make_field<OptionalField>("granteeLogin", grantVIPInput.granteeLogin));
  }
};

struct ttv::chat::graphql::json::GrantVIPGrantVIPError {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& grantVIPError) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>("code", grantVIPError.code));
  }
};

struct ttv::chat::graphql::json::GrantVIPPayloadType {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& payloadType) {
    using namespace ttv::json;

    return std::make_tuple(make_field<OptionalField>(MakeKeyPath("grantVIP", "error"), payloadType.error));
  }
};

struct ttv::chat::graphql::json::GrantVIPInputParams {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& inputParams) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>("input", inputParams.input));
  }
};

struct ttv::chat::graphql::json::GrantVIPErrorCode {
  static auto EnumMap() {
    using namespace ttv::json;

    return std::make_tuple(make_enum_mapping("CHANNEL_NOT_FOUND", ttv::chat::GrantVIPErrorCode::CHANNEL_NOT_FOUND),
      make_enum_mapping("FORBIDDEN", ttv::chat::GrantVIPErrorCode::FORBIDDEN),
      make_enum_mapping("GRANTEE_ALREADY_VIP", ttv::chat::GrantVIPErrorCode::GRANTEE_ALREADY_VIP),
      make_enum_mapping("GRANTEE_CHAT_BANNED", ttv::chat::GrantVIPErrorCode::GRANTEE_CHAT_BANNED),
      make_enum_mapping("GRANTEE_NOT_FOUND", ttv::chat::GrantVIPErrorCode::GRANTEE_NOT_FOUND),
      make_enum_mapping("MAX_VIPS_REACHED", ttv::chat::GrantVIPErrorCode::MAX_VIPS_REACHED),
      make_enum_mapping("VIP_ACHIEVEMENT_INCOMPLETE", ttv::chat::GrantVIPErrorCode::VIP_ACHIEVEMENT_INCOMPLETE));
  }

  static auto GetFallbackValue() { return ttv::chat::GrantVIPErrorCode::UNKNOWN; }
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::GrantVIPQueryInfo::GrantVIPInput> {
  using Type = ObjectSchema<ttv::chat::graphql::json::GrantVIPGrantVIPInput>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::GrantVIPQueryInfo::GrantVIPError> {
  using Type = ObjectSchema<ttv::chat::graphql::json::GrantVIPGrantVIPError>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::GrantVIPQueryInfo::PayloadType> {
  using Type = ObjectSchema<ttv::chat::graphql::json::GrantVIPPayloadType>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::GrantVIPQueryInfo::InputParams> {
  using Type = ObjectSchema<ttv::chat::graphql::json::GrantVIPInputParams>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::GrantVIPErrorCode> {
  using Type = EnumSchema<ttv::chat::graphql::json::GrantVIPErrorCode>;
};
