/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/jsonserialization.h"
#include "twitchsdk/core/optional.h"

namespace ttv {
namespace chat {
namespace graphql {
namespace json {
struct RevokeVIPRevokeVIPInput;
struct RevokeVIPRevokeVIPError;
struct RevokeVIPPayloadType;
struct RevokeVIPInputParams;
struct RevokeVIPErrorCode;
}  // namespace json

struct RevokeVIPQueryInfo {
  struct RevokeVIPInput {
    std::string channelID;
    ttv::Optional<std::string> revokeeID;
    ttv::Optional<std::string> revokeeLogin;
  };

  struct RevokeVIPError {
    RevokeVIPErrorCode code;
  };

  struct PayloadType {
    ttv::Optional<RevokeVIPError> error;
  };

  struct InputParams {
    RevokeVIPInput input;
    std::string authToken;
  };

  static constexpr const char* kTaskName = "GraphQLTask: RevokeVIP";
  static constexpr auto kQuery = R"(
                    # gen_full
                    mutation RevokeVIP($input: RevokeVIPInput!)
                    {
                        revokeVIP(input: $input)
                        {
                            error
                            {
                                code
                            }
                        }
                    }
                )";
};

}  // namespace graphql
}  // namespace chat
}  // namespace ttv

struct ttv::chat::graphql::json::RevokeVIPRevokeVIPInput {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& revokeVIPInput) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>("channelID", revokeVIPInput.channelID),
      make_field<OptionalField>("revokeeID", revokeVIPInput.revokeeID),
      make_field<OptionalField>("revokeeLogin", revokeVIPInput.revokeeLogin));
  }
};

struct ttv::chat::graphql::json::RevokeVIPRevokeVIPError {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& revokeVIPError) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>("code", revokeVIPError.code));
  }
};

struct ttv::chat::graphql::json::RevokeVIPPayloadType {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& payloadType) {
    using namespace ttv::json;

    return std::make_tuple(make_field<OptionalField>(MakeKeyPath("revokeVIP", "error"), payloadType.error));
  }
};

struct ttv::chat::graphql::json::RevokeVIPInputParams {
  template <typename GraphQLType>
  static auto BindFields(GraphQLType& inputParams) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>("input", inputParams.input));
  }
};

struct ttv::chat::graphql::json::RevokeVIPErrorCode {
  static auto EnumMap() {
    using namespace ttv::json;

    return std::make_tuple(make_enum_mapping("CHANNEL_NOT_FOUND", ttv::chat::RevokeVIPErrorCode::CHANNEL_NOT_FOUND),
      make_enum_mapping("FORBIDDEN", ttv::chat::RevokeVIPErrorCode::FORBIDDEN),
      make_enum_mapping("REVOKEE_NOT_FOUND", ttv::chat::RevokeVIPErrorCode::REVOKEE_NOT_FOUND),
      make_enum_mapping("REVOKEE_NOT_VIP", ttv::chat::RevokeVIPErrorCode::REVOKEE_NOT_VIP));
  }

  static auto GetFallbackValue() { return ttv::chat::RevokeVIPErrorCode::UNKNOWN; }
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::RevokeVIPQueryInfo::RevokeVIPInput> {
  using Type = ObjectSchema<ttv::chat::graphql::json::RevokeVIPRevokeVIPInput>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::RevokeVIPQueryInfo::RevokeVIPError> {
  using Type = ObjectSchema<ttv::chat::graphql::json::RevokeVIPRevokeVIPError>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::RevokeVIPQueryInfo::PayloadType> {
  using Type = ObjectSchema<ttv::chat::graphql::json::RevokeVIPPayloadType>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::RevokeVIPQueryInfo::InputParams> {
  using Type = ObjectSchema<ttv::chat::graphql::json::RevokeVIPInputParams>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::RevokeVIPErrorCode> {
  using Type = EnumSchema<ttv::chat::graphql::json::RevokeVIPErrorCode>;
};
