/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/internal/json/chatjsonobjectdescriptions.h"

#include <string>

namespace ttv {
namespace chat {
namespace graphql {
namespace json {
struct SendRoomMessageInput;
struct SendRoomMessagePayload;
}  // namespace json

struct SendRoomMessageQueryInfo {
  struct PayloadType {
    ChatRoomMessage message;
    SendRoomMessageError error;
  };

  struct InputParams {
    std::string authToken;
    std::string roomId;
    std::string message;
    std::string nonce;
    std::string channelId;
  };

  static constexpr const char* kTaskName = "GraphQLTask: sendRoomMessage";
  static constexpr auto kQuery = R"(
                mutation($input: SendRoomMessageInput!, $channelId: ID)
                {
                    sendRoomMessage(input: $input)
                    {
                        message
                        {
                            id
                            room
                            {
                                id
                            }
                            sentAt
                            deletedAt
                            content
                            {
                                fragments
                                {
                                    text
                                    content
                                    {
                                        ... on Emote
                                        {
                                            id
                                        }
                                        ... on User
                                        {
                                            displayName
                                        }
                                        __typename
                                    }
                                }
                            }
                            sender
                            {
                                id
                                displayName
                                login
                                chatColor
                                displayBadges(channelID: $channelId)
                                {
                                    setID
                                    version
                                }
                                roles
                                {
                                    isGlobalMod
                                    isSiteAdmin
                                    isStaff
                                }
                            }
                        }
                        error
                        {
                            code
                            slowModeDurationSeconds
                            remainingDurationSeconds
                        }
                    }
                })";
};
}  // namespace graphql
}  // namespace chat
}  // namespace ttv

struct ttv::chat::graphql::json::SendRoomMessageInput {
  template <typename InputType>
  static auto BindFields(InputType& input) {
    using namespace ttv::json;

    return std::make_tuple(make_field<RequiredField>(MakeKeyPath("input", "roomID"), input.roomId),
      make_field<RequiredField>(MakeKeyPath("input", "message"), input.message),
      make_field<OptionalField>(MakeKeyPath("input", "nonce"), input.nonce),
      make_field<RequiredField>("channelId", input.channelId));
  }
};

struct ttv::chat::graphql::json::SendRoomMessagePayload {
  template <typename PayloadType>
  static auto BindFields(PayloadType& payload) {
    using namespace ttv::json;

    return std::make_tuple(make_field<OptionalField>(MakeKeyPath("sendRoomMessage", "error"), payload.error),
      make_field<ObjectSchema<ttv::chat::json::description::GraphQLChatRoomMessage>, OptionalField>(
        MakeKeyPath("sendRoomMessage", "message"), payload.message));
  }
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::SendRoomMessageQueryInfo::InputParams> {
  using Type = ObjectSchema<ttv::chat::graphql::json::SendRoomMessageInput>;
};

template <>
struct ttv::json::DefaultSchemaProvider<ttv::chat::graphql::SendRoomMessageQueryInfo::PayloadType> {
  using Type = ObjectSchema<ttv::chat::graphql::json::SendRoomMessagePayload>;
};
