/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2019 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/internal/json/chatjsonobjectdescriptions.h"
#include "twitchsdk/core/internal/graphql/utilities/graphqlutilities.h"

namespace ttv {
namespace chat {
namespace graphql {

namespace {
BadgeImage ToBadgeImageUrl(const std::string& url, float scale) {
  BadgeImage image;
  image.url = url;
  image.scale = scale;
  return image;
}
}  // namespace

template <typename GQLEnumType>
BadgeVersion::Action ToBadgeAction(GQLEnumType actionType) {
  switch (actionType) {
    case GQLEnumType::SUBSCRIBE:
      return BadgeVersion::Action::Subscribe;
    case GQLEnumType::GET_TURBO:
      return BadgeVersion::Action::GetTurbo;
    case GQLEnumType::GET_BITS:
      return BadgeVersion::Action::GetBits;
    case GQLEnumType::VISIT_URL:
      return BadgeVersion::Action::VisitUrl;
  }

  return BadgeVersion::Action::None;
}

template <typename GQLType>
BadgeVersion ToBadgeVersion(const GQLType& gqlBadge) {
  BadgeVersion result;

  result.name = gqlBadge.version;
  result.title = gqlBadge.title;
  result.description = gqlBadge.description;
  result.clickUrl = gqlBadge.clickURL.ValueOrDefault("");

  result.images.push_back(ToBadgeImageUrl(gqlBadge.imageUrlNormal, 1.0));
  result.images.push_back(ToBadgeImageUrl(gqlBadge.imageUrlDouble, 2.0));
  result.images.push_back(ToBadgeImageUrl(gqlBadge.imageUrlQuadruple, 4.0));

  if (gqlBadge.onClickAction.HasValue()) {
    result.clickAction = ToBadgeAction(gqlBadge.onClickAction.Value());
  } else {
    result.clickAction = BadgeVersion::Action::None;
  }

  return result;
}

}  // namespace graphql
}  // namespace chat
}  // namespace ttv
