/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2019 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/internal/graphql/utilities/graphqlutilities.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv {
namespace chat {
namespace graphql {

template <typename GQLType>
UserInfo GQLUserToUserInfo(const GQLType& user) {
  UserInfo result;

  result.userName = user.login.ValueOrDefault("");
  result.displayName = user.displayName.ValueOrDefault("");
  result.bio = user.description.ValueOrDefault("");
  result.logoImageUrl = user.profileImageURL.ValueOrDefault("");
  result.userId = static_cast<ttv::UserId>(std::strtoul(user.id.c_str(), nullptr, 10));
  result.createdTimestamp = user.createdAt.ValueOrDefault(0);

  return result;
}
}  // namespace graphql
}  // namespace chat
}  // namespace ttv
